/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.jetty;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.passage.lbc.api.BackendLauncher;
import org.eclipse.passage.lbc.api.BackendRequestDispatcher;
import org.eclipse.passage.lbc.internal.jetty.JettyRequestHandler;
import org.eclipse.passage.lbc.internal.jetty.i18n.JettyMessages;
import org.eclipse.passage.lic.api.LicensingResult;
import org.eclipse.passage.lic.base.LicensingResults;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component
public class JettyServerLauncher
implements BackendLauncher {
    private static final int JETTY_PORT_DEFAULT = 8080;
    private static Logger logger = Log.getLogger((String)JettyServerLauncher.class.getName());
    private Server server;
    private Map<String, BackendRequestDispatcher> requestDispatchers = new HashMap<String, BackendRequestDispatcher>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void bindBackendRequestDispatcher(BackendRequestDispatcher dispatcher, Map<String, Object> context) {
        logger.info(String.format("Bind BackendRequestDispatcher %s with context %s", dispatcher, context), new Object[0]);
        String roleId = String.valueOf(context.get("role"));
        this.requestDispatchers.put(roleId, dispatcher);
    }

    public void unbindBackendRequestDispatcher(BackendRequestDispatcher dispatcher, Map<String, Object> context) {
        logger.info(String.format("Unbind BackendRequestDispatcher %s with context %s", dispatcher, context), new Object[0]);
        String roleId = String.valueOf(context.get("role"));
        this.requestDispatchers.remove(roleId, dispatcher);
    }

    public LicensingResult launch(Map<String, Object> arguments) {
        String source = JettyServerLauncher.class.getName();
        if (this.server != null) {
            return LicensingResults.createError((String)JettyMessages.JettyServerLauncher_e_start_exists, (String)source, (Throwable)new IllegalStateException());
        }
        int port = 8080;
        this.server = new Server(port);
        try {
            this.server.setHandler((Handler)new JettyRequestHandler(this.requestDispatchers.values()));
            this.server.start();
            logger.info(this.server.getState(), new Object[0]);
            return LicensingResults.createOK((String)JettyMessages.JettyServerLauncher_ok_start, (String)source);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), new Object[0]);
            return LicensingResults.createError((String)JettyMessages.JettyServerLauncher_e_start, (String)source, (Throwable)e);
        }
    }

    public LicensingResult terminate() {
        String source = JettyServerLauncher.class.getName();
        if (this.server == null) {
            return LicensingResults.createError((String)JettyMessages.JettyServerLauncher_e_stop_not_started, (String)source, (Throwable)new IllegalStateException());
        }
        try {
            this.server.stop();
            logger.info(this.server.getState(), new Object[0]);
            this.server = null;
            return LicensingResults.createOK((String)JettyMessages.JettyServerLauncher_ok_stop, (String)source);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), new Object[0]);
            return LicensingResults.createError((String)JettyMessages.JettyServerLauncher_e_stop, (String)source, (Throwable)e);
        }
    }
}

