/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.conditions.evaluation;

import java.util.Objects;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionParsingException;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionParsingService;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionProtocol;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ParsedExpression;
import org.eclipse.passage.lic.internal.api.registry.Registry;
import org.eclipse.passage.lic.internal.api.registry.ServiceId;

final class FormalizedExpression {
    private final String raw;
    private final String separator;
    private final Registry<ExpressionProtocol, ExpressionParsingService> parsers;

    FormalizedExpression(String raw, String separator, Registry<ExpressionProtocol, ExpressionParsingService> parsers) {
        Objects.requireNonNull(raw, "RetrievedExpression::raw");
        Objects.requireNonNull(separator, "RetrievedExpression::separator");
        Objects.requireNonNull(parsers, "RetrievedExpression::parsers");
        this.raw = raw;
        this.separator = separator;
        this.parsers = parsers;
    }

    FormalizedExpression(String raw, Registry<ExpressionProtocol, ExpressionParsingService> parsers) {
        this(raw, "!!", parsers);
    }

    ParsedExpression get() throws ExpressionParsingException {
        return this.service().parsed(this.content());
    }

    private ExpressionParsingService service() {
        ExpressionProtocol protocol = this.protocol();
        return this.parsers.hasService((ServiceId)protocol) ? (ExpressionParsingService)this.parsers.service((ServiceId)protocol) : (ExpressionParsingService)this.parsers.service((ServiceId)new ExpressionProtocol.Default());
    }

    private ExpressionProtocol protocol() {
        int index = this.raw.indexOf(this.separator);
        return index <= 0 ? new ExpressionProtocol.Default() : new ExpressionProtocol.Of(this.raw.substring(0, index));
    }

    private String content() {
        int index = this.raw.indexOf(this.separator);
        return index <= 0 ? this.raw : this.raw.substring(index + this.separator.length());
    }
}

