/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc.remote.impl;

import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Supplier;
import org.eclipse.passage.lic.floating.model.api.FloatingLicenseAccess;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.api.io.KeyKeeperRegistry;
import org.eclipse.passage.lic.internal.api.io.StreamCodecRegistry;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.diagnostic.NoSevereErrors;
import org.eclipse.passage.lic.internal.base.diagnostic.code.AbsentLicenseAttendantFile;
import org.eclipse.passage.lic.internal.base.io.LicensingFolder;
import org.eclipse.passage.lic.internal.base.io.UserHomePath;
import org.eclipse.passage.lic.internal.hc.i18n.AccessMessages;
import org.eclipse.passage.lic.internal.hc.remote.Client;
import org.eclipse.passage.lic.internal.hc.remote.Connection;
import org.eclipse.passage.lic.internal.hc.remote.ResponseHandler;
import org.eclipse.passage.lic.internal.hc.remote.impl.AccessPacks;
import org.eclipse.passage.lic.internal.hc.remote.impl.RemoteRequest;
import org.eclipse.passage.lic.internal.hc.remote.impl.RemoteServiceData;

public abstract class ServiceRemote<C extends Connection, T, D extends RemoteServiceData> {
    private final KeyKeeperRegistry keys;
    private final StreamCodecRegistry codecs;
    private final Supplier<Path> source;
    private final Supplier<Client<C, T>> client;

    protected ServiceRemote(KeyKeeperRegistry keys, StreamCodecRegistry codecs, Supplier<Client<C, T>> client, Supplier<Path> source) {
        this.keys = keys;
        this.codecs = codecs;
        this.source = source;
        this.client = client;
    }

    protected ServiceRemote(KeyKeeperRegistry keys, StreamCodecRegistry codecs, Supplier<Client<C, T>> client) {
        this(keys, codecs, client, (Supplier<Path>)new LicensingFolder((Supplier)new UserHomePath()));
    }

    public final ServiceInvocationResult<T> request(D parameters) {
        ServiceInvocationResult<Collection<FloatingLicenseAccess>> accesses = this.accesses(((RemoteServiceData)parameters).product());
        if (!new NoSevereErrors().test(accesses.diagnostic())) {
            return new BaseServiceInvocationResult(accesses.diagnostic());
        }
        if (((Collection)accesses.data().get()).isEmpty()) {
            new BaseServiceInvocationResult(this.noServers());
        }
        return this.withServers(parameters, (Collection)accesses.data().get());
    }

    protected final ServiceInvocationResult<T> withServer(D params, FloatingLicenseAccess access) {
        return this.client.get().request(this.request(params, access), this.handler(access));
    }

    private Trouble noServers() {
        return new Trouble((TroubleCode)new AbsentLicenseAttendantFile(), AccessMessages.RemoteService_no_server);
    }

    private ServiceInvocationResult<Collection<FloatingLicenseAccess>> accesses(LicensedProduct product) {
        return new AccessPacks(product, this.keys, this.codecs, this.source).get();
    }

    protected abstract ServiceInvocationResult<T> withServers(D var1, Collection<FloatingLicenseAccess> var2);

    protected abstract RemoteRequest<C> request(D var1, FloatingLicenseAccess var2);

    protected abstract ResponseHandler<T> handler(FloatingLicenseAccess var1);
}

