/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.licenses.convert;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.conditions.IssuerSignature;
import org.eclipse.passage.lic.base.conditions.BaseIssuerSignature;
import org.eclipse.passage.lic.licenses.model.api.Signature;
import org.eclipse.passage.lic.licenses.model.api.SignatureAttribute;

public final class PIssuerSignature
implements Supplier<IssuerSignature> {
    private final Signature signature;

    public PIssuerSignature(Signature signature) {
        this.signature = signature;
    }

    @Override
    public IssuerSignature get() {
        return new BaseIssuerSignature(this.attributes(), this.parent());
    }

    private Map<String, String> attributes() {
        return this.signature.getAttributes().stream().collect(Collectors.toMap(SignatureAttribute::getName, SignatureAttribute::getValue));
    }

    private Optional<IssuerSignature> parent() {
        Signature parent = this.signature.getParent();
        return parent == null ? Optional.empty() : Optional.of(new PIssuerSignature(parent).get());
    }
}

