/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.handlers;

import java.util.Optional;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.passage.lic.jface.actions.LicensedRunnableUI;
import org.eclipse.passage.lic.jface.resource.LicensingImages;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.licenses.model.meta.LicensesPackage;
import org.eclipse.passage.lic.products.ProductVersionDescriptor;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.loc.dashboard.ui.wizards.IssueLicenseWizard;
import org.eclipse.passage.loc.dashboard.ui.wizards.PersonalDataPack;
import org.eclipse.passage.loc.internal.api.OperatorLicenseService;
import org.eclipse.swt.widgets.Shell;

public class DashboardIssueLicenseHandler {
    private final String feature = "org.eclipse.passage.loc.operator.issue.personal";

    @Execute
    public void execute(IEclipseContext context, @Named(value="org.eclipse.ui.selection") @org.eclipse.e4.core.di.annotations.Optional LicensePlanDescriptor plan, @Named(value="org.eclipse.ui.selection") @org.eclipse.e4.core.di.annotations.Optional UserDescriptor user, @Named(value="org.eclipse.ui.selection") @org.eclipse.e4.core.di.annotations.Optional ProductVersionDescriptor product) {
        Shell shell = (Shell)context.get(Shell.class);
        new LicensedRunnableUI(() -> shell, "org.eclipse.passage.loc.operator.issue.personal", () -> this.startWizard(shell, context, plan, user, product)).run();
    }

    private void startWizard(Shell shell, IEclipseContext context, LicensePlanDescriptor plan, UserDescriptor user, ProductVersionDescriptor product) {
        IssueLicenseWizard wizard = new IssueLicenseWizard(context, new PersonalDataPack(Optional.ofNullable(plan), Optional.ofNullable(user), Optional.ofNullable(product)));
        this.open(shell, wizard);
    }

    private void open(Shell shell, IssueLicenseWizard wizard) {
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        this.shape(dialog);
        dialog.open();
    }

    private void shape(WizardDialog dialog) {
        Shell shell = dialog.getShell();
        shell.setImage(LicensingImages.getImage((String)LicensesPackage.eINSTANCE.getPersonalLicensePack().getName()));
        shell.setSize(Math.max(1000, shell.getSize().x), Math.max(800, shell.getSize().y));
    }

    @CanExecute
    public boolean canExecute(IEclipseContext context) {
        return context.get(OperatorLicenseService.class) != null;
    }
}

