/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.ui.handlers;

import java.util.Optional;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.loc.internal.licenses.ui.i18n.LicensesUiMessages;
import org.eclipse.passage.loc.report.internal.core.license.LicenseReportExportService;
import org.eclipse.passage.loc.report.internal.core.license.LicenseStorage;
import org.eclipse.passage.loc.report.internal.ui.jface.license.ExposedIssuedLicensesReportWizard;
import org.eclipse.swt.widgets.Shell;

public class IssuedLicensesReportHandler {
    @Execute
    public void execute(IEclipseContext context) {
        Optional<LicenseStorage> storage = this.service(LicenseStorage.class, context);
        if (!storage.isPresent()) {
            return;
        }
        Optional<LicenseReportExportService> export = this.service(LicenseReportExportService.class, context);
        if (!export.isPresent()) {
            return;
        }
        new ExposedIssuedLicensesReportWizard(storage.get(), export.get()).accept((Shell)context.get(Shell.class));
    }

    private <S> Optional<S> service(Class<S> service, IEclipseContext context) {
        Optional<Object> implementation = Optional.ofNullable(context.get(service));
        if (!implementation.isPresent()) {
            MessageDialog.openError((Shell)((Shell)context.get(Shell.class)), (String)LicensesUiMessages.IssuedLicensesReportHandler_unavailableTitle, (String)NLS.bind((String)LicensesUiMessages.IssuedLicensesReportHandler_unavailableMessage, (Object)service.getName()));
        }
        return implementation;
    }
}

