/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workspace;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.core.runtime.Platform;

public final class StoreResourceSet {
    private final Supplier<Path> base;
    private final String domain;

    public StoreResourceSet(Supplier<Path> path, String domain) {
        this.base = Objects.requireNonNull(path);
        this.domain = Objects.requireNonNull(domain);
    }

    public void store(List<String> locations) {
        try {
            Path parent = this.base.get();
            Files.createDirectories(parent, new FileAttribute[0]);
            Path path = parent.resolve(this.domain);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.write(path, locations, new OpenOption[0]);
        }
        catch (Exception e) {
            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
        }
    }
}

