/*******************************************************************************
 * Copyright (c) 2018, 2020 ArSysOp
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0/.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     ArSysOp - initial API and implementation
 *******************************************************************************/
package org.eclipse.passage.lic.licenses.edit.providers;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.passage.lic.licenses.model.util.LicensesAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * 
 * <!-- end-user-doc -->
 * @generated
 */
public class LicensesItemProviderAdapterFactory extends LicensesAdapterFactory
		implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LicensesItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.AgreementData} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.1
	 * @generated
	 */
	protected AgreementDataItemProvider agreementDataItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.AgreementData}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.1
	 * @generated
	 */
	@Override
	public Adapter createAgreementDataAdapter() {
		if (agreementDataItemProvider == null) {
			agreementDataItemProvider = new AgreementDataItemProvider(this);
		}

		return agreementDataItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.LicensePlan} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LicensePlanItemProvider licensePlanItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.LicensePlan}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLicensePlanAdapter() {
		if (licensePlanItemProvider == null) {
			licensePlanItemProvider = new LicensePlanItemProvider(this);
		}

		return licensePlanItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.LicensePlanFeature} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LicensePlanFeatureItemProvider licensePlanFeatureItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.LicensePlanFeature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLicensePlanFeatureAdapter() {
		if (licensePlanFeatureItemProvider == null) {
			licensePlanFeatureItemProvider = new LicensePlanFeatureItemProvider(this);
		}

		return licensePlanFeatureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.PersonalFeatureGrant} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected PersonalFeatureGrantItemProvider personalFeatureGrantItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.PersonalFeatureGrant}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createPersonalFeatureGrantAdapter() {
		if (personalFeatureGrantItemProvider == null) {
			personalFeatureGrantItemProvider = new PersonalFeatureGrantItemProvider(this);
		}

		return personalFeatureGrantItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.PersonalLicensePack} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected PersonalLicensePackItemProvider personalLicensePackItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.PersonalLicensePack}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createPersonalLicensePackAdapter() {
		if (personalLicensePackItemProvider == null) {
			personalLicensePackItemProvider = new PersonalLicensePackItemProvider(this);
		}

		return personalLicensePackItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.FloatingLicensePack} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected FloatingLicensePackItemProvider floatingLicensePackItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.FloatingLicensePack}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createFloatingLicensePackAdapter() {
		if (floatingLicensePackItemProvider == null) {
			floatingLicensePackItemProvider = new FloatingLicensePackItemProvider(this);
		}

		return floatingLicensePackItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.PersonalLicenseRequisites} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected PersonalLicenseRequisitesItemProvider personalLicenseRequisitesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.PersonalLicenseRequisites}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createPersonalLicenseRequisitesAdapter() {
		if (personalLicenseRequisitesItemProvider == null) {
			personalLicenseRequisitesItemProvider = new PersonalLicenseRequisitesItemProvider(this);
		}

		return personalLicenseRequisitesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.FloatingLicenseRequisites} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected FloatingLicenseRequisitesItemProvider floatingLicenseRequisitesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.FloatingLicenseRequisites}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createFloatingLicenseRequisitesAdapter() {
		if (floatingLicenseRequisitesItemProvider == null) {
			floatingLicenseRequisitesItemProvider = new FloatingLicenseRequisitesItemProvider(this);
		}

		return floatingLicenseRequisitesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.ProductRef} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected ProductRefItemProvider productRefItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.ProductRef}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createProductRefAdapter() {
		if (productRefItemProvider == null) {
			productRefItemProvider = new ProductRefItemProvider(this);
		}

		return productRefItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.FeatureRef} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected FeatureRefItemProvider featureRefItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.FeatureRef}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createFeatureRefAdapter() {
		if (featureRefItemProvider == null) {
			featureRefItemProvider = new FeatureRefItemProvider(this);
		}

		return featureRefItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.UserRef} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected UserRefItemProvider userRefItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.UserRef}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createUserRefAdapter() {
		if (userRefItemProvider == null) {
			userRefItemProvider = new UserRefItemProvider(this);
		}

		return userRefItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.CompanyRef} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected CompanyRefItemProvider companyRefItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.CompanyRef}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createCompanyRefAdapter() {
		if (companyRefItemProvider == null) {
			companyRefItemProvider = new CompanyRefItemProvider(this);
		}

		return companyRefItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.FloatingServer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected FloatingServerItemProvider floatingServerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.FloatingServer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createFloatingServerAdapter() {
		if (floatingServerItemProvider == null) {
			floatingServerItemProvider = new FloatingServerItemProvider(this);
		}

		return floatingServerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.UserGrant} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected UserGrantItemProvider userGrantItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.UserGrant}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createUserGrantAdapter() {
		if (userGrantItemProvider == null) {
			userGrantItemProvider = new UserGrantItemProvider(this);
		}

		return userGrantItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.FeatureGrant} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected FeatureGrantItemProvider featureGrantItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.FeatureGrant}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createFeatureGrantAdapter() {
		if (featureGrantItemProvider == null) {
			featureGrantItemProvider = new FeatureGrantItemProvider(this);
		}

		return featureGrantItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected ValidityPeriodClosedItemProvider validityPeriodClosedItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createValidityPeriodClosedAdapter() {
		if (validityPeriodClosedItemProvider == null) {
			validityPeriodClosedItemProvider = new ValidityPeriodClosedItemProvider(this);
		}

		return validityPeriodClosedItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.EvaluationInstructions} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected EvaluationInstructionsItemProvider evaluationInstructionsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.EvaluationInstructions}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createEvaluationInstructionsAdapter() {
		if (evaluationInstructionsItemProvider == null) {
			evaluationInstructionsItemProvider = new EvaluationInstructionsItemProvider(this);
		}

		return evaluationInstructionsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.VersionMatch} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected VersionMatchItemProvider versionMatchItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.VersionMatch}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createVersionMatchAdapter() {
		if (versionMatchItemProvider == null) {
			versionMatchItemProvider = new VersionMatchItemProvider(this);
		}

		return versionMatchItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.FloatingLicenseAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected FloatingLicenseAccessItemProvider floatingLicenseAccessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.FloatingLicenseAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createFloatingLicenseAccessAdapter() {
		if (floatingLicenseAccessItemProvider == null) {
			floatingLicenseAccessItemProvider = new FloatingLicenseAccessItemProvider(this);
		}

		return floatingLicenseAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.FloatingServerConnection} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected FloatingServerConnectionItemProvider floatingServerConnectionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.FloatingServerConnection}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createFloatingServerConnectionAdapter() {
		if (floatingServerConnectionItemProvider == null) {
			floatingServerConnectionItemProvider = new FloatingServerConnectionItemProvider(this);
		}

		return floatingServerConnectionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.GrantAcqisition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected GrantAcqisitionItemProvider grantAcqisitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.GrantAcqisition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createGrantAcqisitionAdapter() {
		if (grantAcqisitionItemProvider == null) {
			grantAcqisitionItemProvider = new GrantAcqisitionItemProvider(this);
		}

		return grantAcqisitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.Signature} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected SignatureItemProvider signatureItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.Signature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createSignatureAdapter() {
		if (signatureItemProvider == null) {
			signatureItemProvider = new SignatureItemProvider(this);
		}

		return signatureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.licenses.model.api.SignatureAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	protected SignatureAttributeItemProvider signatureAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.licenses.model.api.SignatureAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @since 2.0
	 * @generated
	 */
	@Override
	public Adapter createSignatureAttributeAdapter() {
		if (signatureAttributeItemProvider == null) {
			signatureAttributeItemProvider = new SignatureAttributeItemProvider(this);
		}

		return signatureAttributeItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * 
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (agreementDataItemProvider != null)
			agreementDataItemProvider.dispose();
		if (companyRefItemProvider != null)
			companyRefItemProvider.dispose();
		if (evaluationInstructionsItemProvider != null)
			evaluationInstructionsItemProvider.dispose();
		if (featureGrantItemProvider != null)
			featureGrantItemProvider.dispose();
		if (featureRefItemProvider != null)
			featureRefItemProvider.dispose();
		if (floatingLicenseAccessItemProvider != null)
			floatingLicenseAccessItemProvider.dispose();
		if (floatingLicensePackItemProvider != null)
			floatingLicensePackItemProvider.dispose();
		if (floatingLicenseRequisitesItemProvider != null)
			floatingLicenseRequisitesItemProvider.dispose();
		if (floatingServerItemProvider != null)
			floatingServerItemProvider.dispose();
		if (floatingServerConnectionItemProvider != null)
			floatingServerConnectionItemProvider.dispose();
		if (grantAcqisitionItemProvider != null)
			grantAcqisitionItemProvider.dispose();
		if (licensePlanItemProvider != null)
			licensePlanItemProvider.dispose();
		if (licensePlanFeatureItemProvider != null)
			licensePlanFeatureItemProvider.dispose();
		if (personalFeatureGrantItemProvider != null)
			personalFeatureGrantItemProvider.dispose();
		if (personalLicensePackItemProvider != null)
			personalLicensePackItemProvider.dispose();
		if (personalLicenseRequisitesItemProvider != null)
			personalLicenseRequisitesItemProvider.dispose();
		if (productRefItemProvider != null)
			productRefItemProvider.dispose();
		if (signatureItemProvider != null)
			signatureItemProvider.dispose();
		if (signatureAttributeItemProvider != null)
			signatureAttributeItemProvider.dispose();
		if (userGrantItemProvider != null)
			userGrantItemProvider.dispose();
		if (userRefItemProvider != null)
			userRefItemProvider.dispose();
		if (validityPeriodClosedItemProvider != null)
			validityPeriodClosedItemProvider.dispose();
		if (versionMatchItemProvider != null)
			versionMatchItemProvider.dispose();
	}

}
