/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.ui.jface.license;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.passage.lic.licenses.model.api.LicensePlan;
import org.eclipse.passage.loc.report.internal.ui.i18n.ExportLicenseReportWizardMessages;
import org.eclipse.passage.loc.report.internal.ui.i18n.ExportWizardMessages;
import org.eclipse.passage.loc.report.internal.ui.jface.PageObserver;
import org.eclipse.passage.loc.report.internal.ui.jface.license.LicensePlans;
import org.eclipse.passage.loc.report.internal.ui.jface.license.PreviewPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

final class PlansPage
extends WizardPage {
    private final LicensePlan[] plans;
    private final Set<LicensePlan> selected;
    private final PageObserver preview;
    private Button all;
    private Button none;
    private CheckboxTableViewer viewer;

    protected PlansPage(LicensePlans plans, PreviewPage preview) {
        super("scope");
        this.preview = preview;
        this.plans = plans.get();
        this.selected = new HashSet<LicensePlan>();
        this.setTitle(ExportLicenseReportWizardMessages.PlansPage_title);
        this.setMessage(ExportLicenseReportWizardMessages.PlansPage_description);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        this.createViewer(content);
        this.createButtons(content);
        this.setControl((Control)content);
    }

    void installInitial() {
        this.selected.addAll(Arrays.asList(this.plans));
        this.viewer.refresh();
        this.updateControls();
    }

    Set<String> identifiers() {
        return this.selected.stream().map(LicensePlan::getIdentifier).collect(Collectors.toSet());
    }

    private CheckboxTableViewer createViewer(Composite content) {
        this.viewer = CheckboxTableViewer.newCheckList((Composite)content, (int)68352);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createColumns();
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return PlansPage.this.selected.contains(element);
            }
        });
        this.viewer.setInput((Object)this.plans);
        return this.viewer;
    }

    private void createButtons(Composite content) {
        Composite controls = new Composite(content, 0);
        controls.setLayoutData((Object)new GridData(131072, 128, false, false));
        controls.setLayout((Layout)new FillLayout(512));
        this.all = new Button(controls, 8);
        this.all.setText(ExportWizardMessages.ScopePage_selectAll);
        this.none = new Button(controls, 8);
        this.none.setText(ExportWizardMessages.ScopePage_selctNone);
        this.all.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Arrays.stream(this.plans).forEach(this.selected::add);
            this.viewer.refresh();
            this.updateControls();
        }));
        this.none.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.selected.clear();
            this.viewer.refresh();
            this.updateControls();
        }));
        this.viewer.addCheckStateListener(e -> {
            if (e.getChecked()) {
                this.selected.add((LicensePlan)e.getElement());
            } else {
                this.selected.remove(e.getElement());
            }
            this.updateControls();
        });
    }

    private void updateControls() {
        this.updateLocalControls();
        this.preview.update();
    }

    private void updateLocalControls() {
        this.all.setEnabled(this.plans.length > 0 && this.selected.size() < this.plans.length);
        this.none.setEnabled(!this.selected.isEmpty());
    }

    private void createColumns() {
        TableViewerColumn id = new TableViewerColumn((TableViewer)this.viewer, 0);
        id.getColumn().setWidth(250);
        id.getColumn().setText(ExportLicenseReportWizardMessages.PlansPage_columnId);
        id.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((LicensePlan)element).getIdentifier();
            }
        });
        TableViewerColumn name = new TableViewerColumn((TableViewer)this.viewer, 0);
        name.getColumn().setWidth(250);
        name.getColumn().setText(ExportLicenseReportWizardMessages.PlansPage_columnName);
        name.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((LicensePlan)element).getName();
            }
        });
    }
}

