/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.reviews.frame.core.utils.Tracer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class R4EUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.mylyn.reviews.r4e.ui";
    public static final String JDT_PLUGIN_ID = "org.eclipse.jdt.core";
    public static final String CDT_PLUGIN_ID = "org.eclipse.cdt.core";
    public static final String R4E_REPORT_PLUGIN_ID = "org.eclipse.mylyn.reviews.r4e.report";
    private static R4EUIPlugin Fplugin;
    public static Tracer Ftracer;
    private FormColors fFormColors;
    private static boolean FJDTAvailable;
    private static boolean FCDTAvailable;
    private static boolean FReportAvailable;

    static {
        FJDTAvailable = false;
        FCDTAvailable = false;
        FReportAvailable = false;
    }

    public R4EUIPlugin() {
        Bundle bdleReport;
        Bundle bdleCDT;
        Bundle bdleJDT = Platform.getBundle((String)JDT_PLUGIN_ID);
        if (bdleJDT != null) {
            FJDTAvailable = true;
        }
        if ((bdleCDT = Platform.getBundle((String)CDT_PLUGIN_ID)) != null) {
            FCDTAvailable = true;
        }
        if ((bdleReport = Platform.getBundle((String)R4E_REPORT_PLUGIN_ID)) != null) {
            FReportAvailable = true;
        }
    }

    public void start(BundleContext aContext) throws Exception {
        super.start(aContext);
        Fplugin = this;
        Ftracer = new Tracer();
        Ftracer.init(PLUGIN_ID);
        Ftracer.traceDebug("plugin started");
    }

    public void stop(BundleContext aContext) throws Exception {
        if (this.fFormColors != null) {
            this.fFormColors.dispose();
            this.fFormColors = null;
        }
        Fplugin = null;
        super.stop(aContext);
        Ftracer.traceDebug("plugin stopped");
    }

    public FormColors getFormColors(Display display) {
        if (this.fFormColors == null) {
            this.fFormColors = new FormColors(display);
            this.fFormColors.markShared();
        }
        return this.fFormColors;
    }

    public static R4EUIPlugin getDefault() {
        return Fplugin;
    }

    public static boolean isJDTAvailable() {
        return FJDTAvailable;
    }

    public static boolean isCDTAvailable() {
        return FCDTAvailable;
    }

    public static boolean isUserReportAvailable() {
        return FReportAvailable;
    }

    public void logError(String aMsg, Exception ae) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, aMsg, (Throwable)ae));
    }

    public void logWarning(String aMsg, Exception ae) {
        this.getLog().log((IStatus)new Status(2, PLUGIN_ID, 0, aMsg, (Throwable)ae));
    }

    public void logInfo(String aMsg, Exception ae) {
        this.getLog().log((IStatus)new Status(1, PLUGIN_ID, 0, aMsg, (Throwable)ae));
    }
}

