/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddAssignHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Add Assignees to Element...";

    public Object execute(final ExecutionEvent aEvent) {
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = R4EUIConstants.R4E_UI_JOB_FAMILY;
            }

            public boolean belongsTo(Object family) {
                return this.familyName.equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)aEvent);
                if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                    Object element2 = null;
                    element2 = ((IStructuredSelection)selection).getFirstElement();
                    if (!(element2 instanceof IR4EUIModelElement)) {
                        return Status.CANCEL_STATUS;
                    }
                    List<R4EParticipant> participants = UIUtils.getAssignParticipants();
                    if (participants.size() > 0) {
                        monitor.beginTask(AddAssignHandler.COMMAND_MESSAGE, ((IStructuredSelection)selection).size());
                        R4EUIModelController.setJobInProgress(true);
                        for (Object element2 : (IStructuredSelection)selection) {
                            if (!(element2 instanceof IR4EUIModelElement)) continue;
                            R4EUIPlugin.Ftracer.traceInfo("Add Assignees..." + ((IR4EUIModelElement)element2).getName());
                            ((IR4EUIModelElement)element2).addAssignees(participants);
                            monitor.worked(1);
                            if (!monitor.isCanceled()) continue;
                            R4EUIModelController.setJobInProgress(false);
                            UIUtils.setNavigatorViewFocus((IR4EUIModelElement)element2, 0);
                            return Status.CANCEL_STATUS;
                        }
                        R4EUIModelController.setJobInProgress(false);
                    }
                    element2 = ((IStructuredSelection)selection).getFirstElement();
                    UIUtils.setNavigatorViewFocus((IR4EUIModelElement)element2, 0);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

