/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.ui.handlers.HandlerUtil;

public class CloseElementHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Closing Element...";

    public Object execute(final ExecutionEvent aEvent) {
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = R4EUIConstants.R4E_UI_JOB_FAMILY;
            }

            public boolean belongsTo(Object family) {
                return this.familyName.equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(CloseElementHandler.COMMAND_MESSAGE, -1);
                ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)aEvent);
                if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                    R4EUIModelController.setJobInProgress(true);
                    IR4EUIModelElement element = (IR4EUIModelElement)((IStructuredSelection)selection).getFirstElement();
                    R4EUIPlugin.Ftracer.traceInfo("Closing element " + element.getName());
                    element.close();
                    R4EUIModelController.setJobInProgress(false);
                    UIUtils.setNavigatorViewFocus(element, 0);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

