/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mylyn.reviews.frame.core.model.Comment;
import org.eclipse.mylyn.reviews.frame.core.model.Item;
import org.eclipse.mylyn.reviews.frame.core.model.Topic;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomaly;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomalyState;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EComment;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileContext;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EItem;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIComment;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedAnomaly;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedFile;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportPostponedHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Importing Postponed Anomalies...";

    public Object execute(ExecutionEvent event) {
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                this.familyName = R4EUIConstants.R4E_UI_JOB_FAMILY;
            }

            public boolean belongsTo(Object family) {
                return this.familyName.equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                R4EUIReviewGroup parentGroup = (R4EUIReviewGroup)R4EUIModelController.getActiveReview().getParent();
                monitor.beginTask(ImportPostponedHandler.COMMAND_MESSAGE, parentGroup.getChildren().length);
                R4EUIModelController.setJobInProgress(true);
                ImportPostponedHandler.importPostponedElements(true, monitor);
                R4EUIModelController.setJobInProgress(false);
                UIUtils.setNavigatorViewFocus(R4EUIModelController.getActiveReview().getPostponedContainer(), -1);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    public static void importPostponedElements(boolean aAddNewAnomalies, IProgressMonitor aMonitor) {
        R4EUIReviewGroup parentGroup = (R4EUIReviewGroup)R4EUIModelController.getActiveReview().getParent();
        IR4EUIModelElement[] iR4EUIModelElementArray = parentGroup.getChildren();
        int n = iR4EUIModelElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                IR4EUIModelElement oldReview = iR4EUIModelElementArray[n2];
                try {
                    if (((R4EUIReviewBasic)oldReview).getName().equals(R4EUIModelController.getActiveReview().getName())) break block10;
                    if (aMonitor != null) {
                        aMonitor.subTask("Processing Review: " + oldReview.getName());
                    }
                    List<R4EAnomaly> oldAnomalies = ImportPostponedHandler.getAnomalies((R4EUIReviewBasic)oldReview);
                    for (R4EAnomaly oldAnomaly : oldAnomalies) {
                        try {
                            ImportPostponedHandler.importAnomaly((R4EUIReviewBasic)oldReview, oldAnomaly, aAddNewAnomalies, aMonitor);
                        }
                        catch (ResourceHandlingException e) {
                            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                        }
                    }
                    CommandUtils.showPostponedElements(R4EUIModelController.getActiveReview());
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                    R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                    R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                }
                catch (CompatibilityException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                    R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                }
                if (aMonitor != null) {
                    aMonitor.worked(1);
                }
            }
            ++n2;
        }
    }

    private static List<R4EAnomaly> getAnomalies(R4EUIReviewBasic aUiOldReview) {
        R4EReview currentReview = R4EUIModelController.getActiveReview().getReview();
        ArrayList<R4EAnomaly> anomaliesToConsider = new ArrayList<R4EAnomaly>();
        try {
            R4EReview oldReview = R4EUIModelController.FModelExt.openR4EReview(((R4EUIReviewGroup)aUiOldReview.getParent()).getReviewGroup(), aUiOldReview.getReview().getName());
            EList oldAnomalies = oldReview.getTopics();
            for (Topic oldAnomaly : oldAnomalies) {
                R4EFileVersion oldAnomalyFile = CommandUtils.getAnomalyParentFile((R4EAnomaly)oldAnomaly);
                if (oldAnomalyFile == null) continue;
                for (Item currentItem : currentReview.getReviewItems()) {
                    if ("true".equals(((R4EItem)currentItem).getInfoAtt().get((Object)"isPostponed"))) continue;
                    EList currentFiles = ((R4EItem)currentItem).getFileContextList();
                    for (R4EFileContext currentFile : currentFiles) {
                        if (currentFile.getTarget() == null || currentFile.getTarget().getPlatformURI() == null || !currentFile.getTarget().getPlatformURI().equals(oldAnomalyFile.getPlatformURI()) || ((R4EAnomaly)oldAnomaly).getInfoAtt().get((Object)"originalAnomalyId") != null) continue;
                        anomaliesToConsider.add((R4EAnomaly)oldAnomaly);
                    }
                }
            }
            R4EUIModelController.FModelExt.closeR4EReview(oldReview);
        }
        catch (ResourceHandlingException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
        }
        catch (CompatibilityException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
        }
        return anomaliesToConsider;
    }

    private static void importAnomaly(R4EUIReviewBasic aUiReview, R4EAnomaly aOldAnomaly, boolean aAddNewAnomalies, IProgressMonitor aMonitor) throws ResourceHandlingException, OutOfSyncException {
        block17: {
            R4EUIPostponedAnomaly foundUiAnomaly;
            block16: {
                R4EFileVersion oldFile;
                R4EUIPostponedContainer uiPostponedContainer = R4EUIModelController.getActiveReview().getPostponedContainer();
                if (uiPostponedContainer == null) {
                    if (aAddNewAnomalies) {
                        uiPostponedContainer = R4EUIModelController.getActiveReview().createPostponedContainer();
                    } else {
                        return;
                    }
                }
                if ((oldFile = CommandUtils.getAnomalyParentFile(aOldAnomaly)) == null) {
                    return;
                }
                List<R4EUIFileContext> postponedUiFileContexts = uiPostponedContainer.getFileContexts();
                R4EUIPostponedFile uiPostponedFile = null;
                for (R4EUIFileContext currentFileContext : postponedUiFileContexts) {
                    if (!currentFileContext.getFileContext().getTarget().getVersionID().equals(oldFile.getVersionID())) continue;
                    uiPostponedFile = (R4EUIPostponedFile)currentFileContext;
                    break;
                }
                if (uiPostponedFile == null) {
                    if (aAddNewAnomalies) {
                        uiPostponedFile = uiPostponedContainer.createFileContext(oldFile);
                    } else {
                        return;
                    }
                }
                IR4EUIModelElement[] uiAnomalies = uiPostponedFile.getChildren();
                foundUiAnomaly = null;
                IR4EUIModelElement[] iR4EUIModelElementArray = uiAnomalies;
                int n = uiAnomalies.length;
                int n2 = 0;
                while (n2 < n) {
                    IR4EUIModelElement uiAnomaly = iR4EUIModelElementArray[n2];
                    R4EAnomaly anomaly = ((R4EUIPostponedAnomaly)uiAnomaly).getAnomaly();
                    String oldAnomalyId = String.valueOf(aOldAnomaly.getId().getUserID()) + "/" + aOldAnomaly.getId().getSequenceID();
                    if (oldAnomalyId.equals(anomaly.getInfoAtt().get((Object)"originalAnomalyId"))) {
                        foundUiAnomaly = (R4EUIPostponedAnomaly)uiAnomaly;
                        break;
                    }
                    ++n2;
                }
                if (foundUiAnomaly != null) break block16;
                if (!aAddNewAnomalies || !aOldAnomaly.getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED)) break block17;
                if (aMonitor != null) {
                    aMonitor.subTask("Importing Postponed Anomaly for Review: " + aUiReview.getName());
                }
                R4EUIPostponedAnomaly uiPostponedAnomaly = uiPostponedFile.createAnomaly(aOldAnomaly, aUiReview.getReview().getName());
                EList comments = aOldAnomaly.getComments();
                for (Comment comment : comments) {
                    uiPostponedAnomaly.createComment((R4EComment)comment);
                }
                break block17;
            }
            foundUiAnomaly.updateAnomaly(aOldAnomaly);
            if (foundUiAnomaly.isEnabled()) {
                EList oldComments = aOldAnomaly.getComments();
                IR4EUIModelElement[] uiComments = foundUiAnomaly.getChildren();
                for (Comment oldComment : oldComments) {
                    R4EUIComment foundUiComment = null;
                    IR4EUIModelElement[] iR4EUIModelElementArray = uiComments;
                    int n = uiComments.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IR4EUIModelElement uiComment = iR4EUIModelElementArray[n3];
                        R4EComment comment = ((R4EUIComment)uiComment).getComment();
                        String oldCommentId = String.valueOf(((R4EComment)oldComment).getId().getUserID()) + ((R4EComment)oldComment).getId().getSequenceID();
                        if (oldCommentId.equals(comment.getInfoAtt().get((Object)"originalCommentId"))) {
                            foundUiComment = (R4EUIComment)uiComment;
                            break;
                        }
                        ++n3;
                    }
                    if (foundUiComment != null) continue;
                    foundUiAnomaly.createComment((R4EComment)oldComment);
                }
            }
        }
    }

    public static void refreshPostponedElements(IProgressMonitor aMonitor) {
        ImportPostponedHandler.importPostponedElements(false, aMonitor);
    }
}

