/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.frame.core.model.Comment;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EComment;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.CommentProperties;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.ui.views.properties.IPropertySource;

public class R4EUIComment
extends R4EUIModelElement {
    private static final String COMMENT_ICON_FILE = "icons/obj16/cmmnt_obj.gif";
    private static final String REMOVE_ELEMENT_COMMAND_NAME = "Disable Comment";
    private static final String REMOVE_ELEMENT_COMMAND_TOOLTIP = "Disable (and Optionally Remove) this Comment from its parent anomaly";
    private static final String RESTORE_ELEMENT_COMMAND_NAME = "Restore Comment";
    private static final String RESTORE_ELEMENT_COMMAND_TOOLTIP = "Restore this disabled Comment";
    private static final int COMMENT_LABEL_LENGTH = 25;
    private final R4EComment fComment;

    public R4EUIComment(IR4EUIModelElement aParent, R4EComment aComment) {
        super(aParent, R4EUIComment.buildCommentName(aComment.getDescription()));
        this.fReadOnly = aParent.isReadOnly();
        this.fComment = aComment;
        this.setImage(COMMENT_ICON_FILE);
    }

    public String getToolTip() {
        return String.valueOf(this.fComment.getUser().getId()) + ": " + this.fComment.getDescription();
    }

    public Object getAdapter(Class adapter) {
        if (IR4EUIModelElement.class.equals((Object)adapter)) {
            return this;
        }
        if (IPropertySource.class.equals((Object)adapter)) {
            return new CommentProperties(this);
        }
        return null;
    }

    private static String buildCommentName(String aDescription) {
        if (aDescription != null) {
            String[] lines = aDescription.split(R4EUIConstants.LINE_FEED);
            if (lines[0].length() > 25) {
                return String.valueOf(lines[0].substring(0, 25)) + "...";
            }
            if (lines.length > 1) {
                return String.valueOf(lines[0]) + "...";
            }
            return lines[0];
        }
        return aDescription;
    }

    public R4EComment getComment() {
        return this.fComment;
    }

    public void setModelData(ReviewComponent aModelComponent) throws ResourceHandlingException, OutOfSyncException {
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fComment, R4EUIModelController.getReviewer());
        this.fComment.setDescription(((Comment)aModelComponent).getDescription());
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    public void setEnabled(boolean aEnabled) throws ResourceHandlingException, OutOfSyncException {
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fComment, R4EUIModelController.getReviewer());
        this.fComment.setEnabled(true);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    public boolean isEnabled() {
        return this.fComment.isEnabled();
    }

    public boolean isOpenEditorCmd() {
        IR4EUIModelElement ancestorElement = this.getParent().getParent().getParent();
        if (!(ancestorElement instanceof R4EUIFileContext)) {
            return false;
        }
        return this.isEnabled() && ((R4EUIFileContext)ancestorElement).getTargetFileVersion() != null;
    }

    public boolean isRemoveElementCmd() {
        return this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    public String getRemoveElementCmdName() {
        return REMOVE_ELEMENT_COMMAND_NAME;
    }

    public String getRemoveElementCmdTooltip() {
        return REMOVE_ELEMENT_COMMAND_TOOLTIP;
    }

    public boolean isRestoreElementCmd() {
        if (!this.getParent().isEnabled()) {
            return false;
        }
        return !this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    public String getRestoreElementCmdName() {
        return RESTORE_ELEMENT_COMMAND_NAME;
    }

    public String getRestoreElementCmdTooltip() {
        return RESTORE_ELEMENT_COMMAND_TOOLTIP;
    }

    public boolean isSendEmailCmd() {
        return this.isEnabled();
    }
}

