/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.DRModelFactory;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRule;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleViolation;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IRuleInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRule;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.RuleViolationProperties;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class R4EUIRuleViolation
extends R4EUIModelElement {
    public static final String RULE_VIOLATION_ICON_FILE = "icons/obj16/ruleviolation_obj.gif";
    private static final String NEW_CHILD_ELEMENT_COMMAND_NAME = "New Rule...";
    private static final String NEW_CHILD_ELEMENT_COMMAND_TOOLTIP = "Add a New Rule to the Current Rule Violation";
    private static final String REMOVE_ELEMENT_COMMAND_NAME = "Disable Rule Violation";
    private static final String REMOVE_ELEMENT_COMMAND_TOOLTIP = "Disable (and Optionally Remove) this Rule Violation from its parent Rule Area";
    private static final String RESTORE_ELEMENT_COMMAND_NAME = "Restore Rule Violation";
    private static final String RESTORE_ELEMENT_COMMAND_TOOLTIP = "Restore this disabled Rule Violation";
    protected R4EDesignRuleViolation fViolation;
    private final List<R4EUIRule> fRules;

    public R4EUIRuleViolation(IR4EUIModelElement aParent, R4EDesignRuleViolation aViolation) {
        super(aParent, aViolation.getName());
        this.fReadOnly = aParent.isReadOnly();
        this.fViolation = aViolation;
        this.fRules = new ArrayList<R4EUIRule>();
        this.setImage(RULE_VIOLATION_ICON_FILE);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IR4EUIModelElement.class.equals((Object)adapter)) {
            return this;
        }
        if (IPropertySource.class.equals((Object)adapter)) {
            return new RuleViolationProperties(this);
        }
        return null;
    }

    public R4EDesignRuleViolation getViolation() {
        return this.fViolation;
    }

    @Override
    public List<ReviewComponent> createChildModelDataElement() {
        ArrayList<ReviewComponent> tempRules = new ArrayList<ReviewComponent>();
        IRuleInputDialog dialog = R4EUIDialogFactory.getInstance().getRuleInputDialog();
        int result = dialog.open();
        if (result == 0) {
            R4EDesignRule tempRule = DRModelFactory.eINSTANCE.createR4EDesignRule();
            tempRule.setId(dialog.getIdValue());
            tempRule.setTitle(dialog.getTitleValue());
            tempRule.setDescription(dialog.getDescriptionValue());
            tempRule.setRank(dialog.getRankValue());
            tempRule.setClass(dialog.getClassValue());
            tempRules.add((ReviewComponent)tempRule);
        }
        return tempRules;
    }

    @Override
    public IR4EUIModelElement[] getChildren() {
        return this.fRules.toArray(new R4EUIRule[this.fRules.size()]);
    }

    public List<R4EUIRule> getViolationList() {
        return this.fRules;
    }

    @Override
    public boolean hasChildren() {
        return this.fRules.size() > 0;
    }

    @Override
    public void close() {
        R4EUIRule rule = null;
        int ruleSize = this.fRules.size();
        int i = 0;
        while (i < ruleSize) {
            rule = this.fRules.get(i);
            rule.close();
            ++i;
        }
        this.fRules.clear();
        this.fOpen = false;
    }

    @Override
    public void open() {
        EList rules = this.fViolation.getRules();
        if (rules != null) {
            R4EUIRule uiRule = null;
            int ruleSize = rules.size();
            int i = 0;
            while (i < ruleSize) {
                if (((R4EDesignRule)rules.get(i)).isEnabled() || R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                    uiRule = new R4EUIRule((IR4EUIModelElement)this, (R4EDesignRule)rules.get(i));
                    this.addChildren(uiRule);
                }
                ++i;
            }
        }
        this.fOpen = true;
    }

    @Override
    public void setEnabled(boolean aEnabled) throws ResourceHandlingException, OutOfSyncException {
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fViolation, R4EUIModelController.getReviewer());
        this.fViolation.setEnabled(true);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    @Override
    public boolean isEnabled() {
        return this.fViolation.isEnabled();
    }

    @Override
    public void addChildren(IR4EUIModelElement aChildToAdd) {
        this.fRules.add((R4EUIRule)aChildToAdd);
    }

    @Override
    public IR4EUIModelElement createChildren(ReviewComponent aModelComponent) throws ResourceHandlingException, OutOfSyncException {
        R4EDesignRule rule = R4EUIModelController.FModelExt.createR4EDesignRule(this.fViolation);
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)rule, R4EUIModelController.getReviewer());
        rule.setId(((R4EDesignRule)aModelComponent).getId());
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        R4EUIRule addedChild = new R4EUIRule((IR4EUIModelElement)this, rule);
        addedChild.setModelData(aModelComponent);
        this.addChildren(addedChild);
        return addedChild;
    }

    @Override
    public void removeChildren(IR4EUIModelElement aChildToRemove, boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        R4EUIRule removedElement = this.fRules.get(this.fRules.indexOf(aChildToRemove));
        R4EDesignRule modelRule = removedElement.getRule();
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelRule, R4EUIModelController.getReviewer());
        modelRule.setEnabled(false);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        if (!R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
            this.fRules.remove(removedElement);
        }
    }

    @Override
    public void removeAllChildren(boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        for (R4EUIRule rule : this.fRules) {
            this.removeChildren(rule, aFileRemove);
        }
    }

    @Override
    public boolean isNewChildElementCmd() {
        return this.isEnabled() && !this.isReadOnly();
    }

    @Override
    public String getNewChildElementCmdName() {
        return NEW_CHILD_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getNewChildElementCmdTooltip() {
        return NEW_CHILD_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isRemoveElementCmd() {
        return this.isEnabled() && !this.isReadOnly();
    }

    @Override
    public String getRemoveElementCmdName() {
        return REMOVE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getRemoveElementCmdTooltip() {
        return REMOVE_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isRestoreElementCmd() {
        return !this.isEnabled() && !this.isReadOnly();
    }

    @Override
    public String getRestoreElementCmdName() {
        return RESTORE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getRestoreElementCmdTooltip() {
        return RESTORE_ELEMENT_COMMAND_TOOLTIP;
    }
}

