/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed;

import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileContext;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedFile;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed.ModelElementTabPropertySection;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class FileContextTabPropertySection
extends ModelElementTabPropertySection {
    protected Text fBaseFileNameText = null;
    protected Text fBaseFilePathAbsoluteText = null;
    protected Text fBaseFilePathProjectText = null;
    protected Text fBaseFilePathRepositoryText = null;
    protected Text fBaseFileVersionText = null;
    protected Text fTargetFileNameText = null;
    protected Text fTargetFilePathAbsoluteText = null;
    protected Text fTargetFilePathProjectText = null;
    protected Text fTargetFilePathRepositoryText = null;
    protected Text fTargetFileVersionText = null;
    private Composite fAssignedToComposite;
    private Text fAssignedToText;
    private Button fAssignedToButton;
    private Button fUnassignedFromButton;

    public void createControls(Composite aParent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(aParent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory widgetFactory = aTabbedPropertySheetPage.getWidgetFactory();
        Composite composite = widgetFactory.createFlatFormComposite(aParent);
        FormData data = null;
        widgetFactory.setBorderStyle(0);
        Group targetFileComposite = widgetFactory.createGroup(composite, "Target File");
        FormLayout targetFileLayout = new FormLayout();
        targetFileComposite.setLayout((Layout)targetFileLayout);
        this.createTargetFileVersionComposite((Composite)targetFileComposite, widgetFactory);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        targetFileComposite.setLayoutData((Object)data);
        Group baseFileComposite = widgetFactory.createGroup(composite, "Base File");
        FormLayout baseFileLayout = new FormLayout();
        baseFileComposite.setLayout((Layout)baseFileLayout);
        this.createBaseFileVersionComposite((Composite)baseFileComposite, widgetFactory);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)targetFileComposite, 4);
        baseFileComposite.setLayoutData((Object)data);
        this.fAssignedToComposite = widgetFactory.createComposite(composite);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)baseFileComposite, 4);
        this.fAssignedToComposite.setToolTipText("Participant assigned to Review this element.");
        this.fAssignedToComposite.setLayoutData((Object)data);
        this.fAssignedToComposite.setLayout((Layout)new GridLayout(3, false));
        widgetFactory.setBorderStyle(2048);
        this.fAssignedToText = widgetFactory.createText(this.fAssignedToComposite, "");
        this.fAssignedToText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fAssignedToText.setEditable(false);
        this.fAssignedToButton = widgetFactory.createButton(this.fAssignedToComposite, "Add...", 0);
        this.fAssignedToButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fAssignedToButton.addListener(13, new Listener(){

            public void handleEvent(Event aEvent) {
                ((R4EUIFileContext)FileContextTabPropertySection.this.fProperties.getElement()).addAssignees(UIUtils.getAssignParticipants());
                FileContextTabPropertySection.this.refresh();
                R4EUIModelController.getNavigatorView().getTreeViewer().refresh();
            }
        });
        this.fUnassignedFromButton = widgetFactory.createButton(this.fAssignedToComposite, "Remove...", 0);
        this.fUnassignedFromButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fUnassignedFromButton.addListener(13, new Listener(){

            public void handleEvent(Event aEvent) {
                ((R4EUIFileContext)FileContextTabPropertySection.this.fProperties.getElement()).removeAssignees(UIUtils.getUnassignParticipants(FileContextTabPropertySection.this.fProperties.getElement()));
                FileContextTabPropertySection.this.refresh();
                R4EUIModelController.getNavigatorView().getTreeViewer().refresh();
            }
        });
        CLabel assignedToLabel = widgetFactory.createCLabel(composite, "Assigned to: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fAssignedToComposite, -5);
        data.top = new FormAttachment((Control)this.fAssignedToComposite, 0, 0x1000000);
        assignedToLabel.setToolTipText("Participant assigned to Review this element.");
        assignedToLabel.setLayoutData((Object)data);
    }

    private void createBaseFileVersionComposite(final Composite aParent, TabbedPropertySheetWidgetFactory aWidgetFactory) {
        this.fBaseFileNameText = aWidgetFactory.createText(aParent, "", 0);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)aParent, 4);
        this.fBaseFileNameText.setEditable(false);
        this.fBaseFileNameText.setToolTipText("The base (or Reference File) Name for the File to Review");
        this.fBaseFileNameText.setLayoutData((Object)data);
        CLabel fileNameLabel = aWidgetFactory.createCLabel(aParent, "Name: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fBaseFileNameText, -5);
        data.top = new FormAttachment((Control)this.fBaseFileNameText, 0, 0x1000000);
        fileNameLabel.setToolTipText("The base (or Reference File) Name for the File to Review");
        fileNameLabel.setLayoutData((Object)data);
        this.fBaseFileVersionText = aWidgetFactory.createText(aParent, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fBaseFileNameText, 4);
        this.fBaseFileVersionText.setEditable(false);
        this.fBaseFileVersionText.setToolTipText("The base (or Reference File) Version for the File to Review");
        this.fBaseFileVersionText.setLayoutData((Object)data);
        CLabel fileVersionLabel = aWidgetFactory.createCLabel(aParent, "Version: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fBaseFileVersionText, -5);
        data.top = new FormAttachment((Control)this.fBaseFileVersionText, 0, 0x1000000);
        fileVersionLabel.setToolTipText("The base (or Reference File) Version for the File to Review");
        fileVersionLabel.setLayoutData((Object)data);
        ExpandableComposite pathSection = aWidgetFactory.createExpandableComposite(aParent, 2);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fBaseFileVersionText, 4);
        pathSection.setLayoutData((Object)data);
        pathSection.setText("Path Information");
        pathSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent aEvent) {
                ScrolledComposite scrolledParent = (ScrolledComposite)aParent.getParent().getParent().getParent().getParent().getParent().getParent();
                scrolledParent.setMinSize(aParent.computeSize(-1, -1));
                scrolledParent.layout(true, true);
            }
        });
        pathSection.setLayout((Layout)new GridLayout(1, false));
        Composite pathSectionClient = aWidgetFactory.createComposite((Composite)pathSection);
        pathSectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        pathSectionClient.setLayout((Layout)new GridLayout(4, false));
        pathSection.setClient((Control)pathSectionClient);
        CLabel filePathRepositoryLabel = aWidgetFactory.createCLabel(pathSectionClient, "Repository Path: ");
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        filePathRepositoryLabel.setToolTipText("The base (or Reference File) Repository Path for the File to Review");
        filePathRepositoryLabel.setLayoutData((Object)gridData);
        this.fBaseFilePathRepositoryText = aWidgetFactory.createText(pathSectionClient, "", 0);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fBaseFilePathRepositoryText.setEditable(false);
        this.fBaseFilePathRepositoryText.setToolTipText("The base (or Reference File) Repository Path for the File to Review");
        this.fBaseFilePathRepositoryText.setLayoutData((Object)gridData);
        CLabel filePathAbsoluteLabel = aWidgetFactory.createCLabel(pathSectionClient, "Absolute Path: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        filePathAbsoluteLabel.setToolTipText("The base (or Reference File) Absolute Path for the File to Review");
        filePathAbsoluteLabel.setLayoutData((Object)gridData);
        this.fBaseFilePathAbsoluteText = aWidgetFactory.createText(pathSectionClient, "", 0);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fBaseFilePathAbsoluteText.setEditable(false);
        this.fBaseFilePathAbsoluteText.setToolTipText("The base (or Reference File) Absolute Path for the File to Review");
        this.fBaseFilePathAbsoluteText.setLayoutData((Object)gridData);
        CLabel filePathProjectLabel = aWidgetFactory.createCLabel(pathSectionClient, "Project Relative Path: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        filePathProjectLabel.setToolTipText("The base (or Reference File) Project Relative Path for the File to Review");
        filePathProjectLabel.setLayoutData((Object)gridData);
        this.fBaseFilePathProjectText = aWidgetFactory.createText(pathSectionClient, "", 0);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fBaseFilePathProjectText.setEditable(false);
        this.fBaseFilePathProjectText.setToolTipText("The base (or Reference File) Project Relative Path for the File to Review");
        this.fBaseFilePathProjectText.setLayoutData((Object)gridData);
    }

    private void createTargetFileVersionComposite(final Composite aParent, TabbedPropertySheetWidgetFactory aWidgetFactory) {
        FormData data = null;
        this.fTargetFileNameText = aWidgetFactory.createText(aParent, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)aParent, 4);
        this.fTargetFileNameText.setEditable(false);
        this.fTargetFileNameText.setToolTipText("The target (or current File) Name for the File to Review");
        this.fTargetFileNameText.setLayoutData((Object)data);
        CLabel fileNameLabel = aWidgetFactory.createCLabel(aParent, "Name: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fTargetFileNameText, -5);
        data.top = new FormAttachment((Control)this.fTargetFileNameText, 0, 0x1000000);
        fileNameLabel.setToolTipText("The target (or current File) Name for the File to Review");
        fileNameLabel.setLayoutData((Object)data);
        this.fTargetFileVersionText = aWidgetFactory.createText(aParent, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fTargetFileNameText, 4);
        this.fTargetFileVersionText.setEditable(false);
        this.fTargetFileVersionText.setToolTipText("The target (or current File) Version for the File to Review");
        this.fTargetFileVersionText.setLayoutData((Object)data);
        CLabel fileVersionLabel = aWidgetFactory.createCLabel(aParent, "Version: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fTargetFileVersionText, -5);
        data.top = new FormAttachment((Control)this.fTargetFileVersionText, 0, 0x1000000);
        fileVersionLabel.setToolTipText("The target (or current File) Version for the File to Review");
        fileVersionLabel.setLayoutData((Object)data);
        ExpandableComposite pathSection = aWidgetFactory.createExpandableComposite(aParent, 66);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fTargetFileVersionText, 4);
        pathSection.setLayoutData((Object)data);
        pathSection.setText("Path Information");
        pathSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent aEvent) {
                ScrolledComposite scrolledParent = (ScrolledComposite)aParent.getParent().getParent().getParent().getParent().getParent().getParent();
                scrolledParent.setMinSize(aParent.computeSize(-1, -1));
                scrolledParent.layout(true, true);
            }
        });
        pathSection.setLayout((Layout)new GridLayout(1, false));
        Composite pathSectionClient = aWidgetFactory.createComposite((Composite)pathSection);
        pathSectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        pathSectionClient.setLayout((Layout)new GridLayout(4, false));
        pathSection.setClient((Control)pathSectionClient);
        CLabel filePathRepositoryLabel = aWidgetFactory.createCLabel(pathSectionClient, "Repository Path: ");
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        filePathRepositoryLabel.setToolTipText("The base (or Reference File) Repository Path for the File to Review");
        filePathRepositoryLabel.setLayoutData((Object)gridData);
        this.fTargetFilePathRepositoryText = aWidgetFactory.createText(pathSectionClient, "", 0);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fTargetFilePathRepositoryText.setEditable(false);
        this.fTargetFilePathRepositoryText.setToolTipText("The base (or Reference File) Repository Path for the File to Review");
        this.fTargetFilePathRepositoryText.setLayoutData((Object)gridData);
        CLabel filePathAbsoluteLabel = aWidgetFactory.createCLabel(pathSectionClient, "Absolute Path: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        filePathAbsoluteLabel.setToolTipText("The base (or Reference File) Absolute Path for the File to Review");
        filePathAbsoluteLabel.setLayoutData((Object)gridData);
        this.fTargetFilePathAbsoluteText = aWidgetFactory.createText(pathSectionClient, "", 0);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fTargetFilePathAbsoluteText.setEditable(false);
        this.fTargetFilePathAbsoluteText.setToolTipText("The base (or Reference File) Absolute Path for the File to Review");
        this.fTargetFilePathAbsoluteText.setLayoutData((Object)gridData);
        CLabel filePathProjectLabel = aWidgetFactory.createCLabel(pathSectionClient, "Project Relative Path: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        filePathProjectLabel.setToolTipText("The base (or Reference File) Project Relative Path for the File to Review");
        filePathProjectLabel.setLayoutData((Object)gridData);
        this.fTargetFilePathProjectText = aWidgetFactory.createText(pathSectionClient, "", 0);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fTargetFilePathProjectText.setEditable(false);
        this.fTargetFilePathProjectText.setToolTipText("The base (or Reference File) Project Relative Path for the File to Review");
        this.fTargetFilePathProjectText.setLayoutData((Object)gridData);
    }

    public void refresh() {
        this.fRefreshInProgress = true;
        R4EFileContext modelFile = ((R4EUIFileContext)this.fProperties.getElement()).getFileContext();
        R4EFileVersion baseVersion = modelFile.getBase();
        if (modelFile.getBase() != null) {
            this.fBaseFileNameText.setText(baseVersion.getName());
            this.fBaseFilePathRepositoryText.setText(baseVersion.getRepositoryPath());
            this.fBaseFilePathProjectText.setText(UIUtils.getProjectPath(baseVersion));
            IResource baseResource = baseVersion.getResource();
            if (baseResource != null) {
                if (CommandUtils.useWorkspaceResource(baseVersion)) {
                    this.fBaseFilePathAbsoluteText.setText(baseResource.getLocation().toPortableString());
                } else {
                    this.fBaseFilePathAbsoluteText.setText("(Not Present)");
                }
            } else {
                this.fBaseFilePathAbsoluteText.setText("(Not Present)");
            }
            this.fBaseFileVersionText.setText(baseVersion.getVersionID());
        } else {
            this.fBaseFileNameText.setText("(Not Present)");
            this.fBaseFilePathRepositoryText.setText("");
            this.fBaseFilePathAbsoluteText.setText("");
            this.fBaseFilePathProjectText.setText("");
            this.fBaseFileVersionText.setText("");
        }
        R4EFileVersion targetVersion = modelFile.getTarget();
        if (targetVersion != null) {
            this.fTargetFileNameText.setText(targetVersion.getName());
            this.fTargetFilePathRepositoryText.setText(targetVersion.getRepositoryPath());
            this.fTargetFilePathProjectText.setText(UIUtils.getProjectPath(targetVersion));
            IResource targetResource = targetVersion.getResource();
            if (targetResource != null) {
                if (CommandUtils.useWorkspaceResource(targetVersion)) {
                    this.fTargetFilePathAbsoluteText.setText(targetResource.getLocation().toPortableString());
                } else {
                    this.fTargetFilePathAbsoluteText.setText("(Not Present)");
                }
            } else {
                this.fTargetFilePathAbsoluteText.setText("(Not Present)");
            }
            this.fTargetFileVersionText.setText(targetVersion.getVersionID());
        } else {
            this.fTargetFileNameText.setText("(Not Present)");
            this.fTargetFilePathRepositoryText.setText("");
            this.fTargetFilePathAbsoluteText.setText("");
            this.fTargetFilePathProjectText.setText("");
            this.fTargetFileVersionText.setText("");
        }
        EList assignedParticipants = modelFile.getAssignedTo();
        this.fAssignedToText.setText(UIUtils.formatAssignedParticipants((EList<String>)assignedParticipants));
        this.setEnabledFields();
        this.fRefreshInProgress = false;
    }

    protected void setEnabledFields() {
        if (this.fProperties.getElement() instanceof R4EUIPostponedFile) {
            this.fBaseFileNameText.getParent().getParent().setVisible(false);
            return;
        }
        if (R4EUIModelController.isJobInProgress() || this.fProperties.getElement().isReadOnly() || ((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED) || !this.fProperties.getElement().isEnabled()) {
            this.fBaseFileNameText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fBaseFilePathRepositoryText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fBaseFilePathAbsoluteText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fBaseFilePathProjectText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fBaseFileVersionText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fTargetFileNameText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fTargetFilePathRepositoryText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fTargetFilePathAbsoluteText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fTargetFilePathProjectText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fTargetFileVersionText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fAssignedToText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fAssignedToButton.setEnabled(false);
            this.fUnassignedFromButton.setEnabled(false);
        } else {
            this.fBaseFileNameText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fBaseFilePathRepositoryText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fBaseFilePathAbsoluteText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fBaseFilePathProjectText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fBaseFileVersionText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fTargetFileNameText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fTargetFilePathRepositoryText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fTargetFilePathAbsoluteText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fTargetFilePathProjectText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fTargetFileVersionText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fAssignedToText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fAssignedToButton.setEnabled(true);
            if (this.fAssignedToText.getText().length() > 0) {
                this.fUnassignedFromButton.setEnabled(true);
            } else {
                this.fUnassignedFromButton.setEnabled(false);
            }
        }
    }
}

