/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContent;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed.ModelElementTabPropertySection;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ContentsTabPropertySection
extends ModelElementTabPropertySection {
    private Text fPositionText = null;
    private Composite fAssignedToComposite;
    private Text fAssignedToText;
    private Button fAssignedToButton;
    private Button fUnassignedFromButton;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory widgetFactory = aTabbedPropertySheetPage.getWidgetFactory();
        Composite composite = widgetFactory.createFlatFormComposite(parent);
        FormData data = null;
        widgetFactory.setBorderStyle(0);
        this.fPositionText = widgetFactory.createText(composite, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.fPositionText.setEditable(false);
        this.fPositionText.setToolTipText("The Position in the Parent File of the Selected Contents");
        this.fPositionText.setLayoutData((Object)data);
        CLabel positionLabel = widgetFactory.createCLabel(composite, "Position: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fPositionText, -5);
        data.top = new FormAttachment((Control)this.fPositionText, 0, 0x1000000);
        positionLabel.setToolTipText("The Position in the Parent File of the Selected Contents");
        positionLabel.setLayoutData((Object)data);
        this.fAssignedToComposite = widgetFactory.createComposite(composite);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fPositionText, 4);
        this.fAssignedToComposite.setToolTipText("Participant assigned to Review this element.");
        this.fAssignedToComposite.setLayoutData((Object)data);
        this.fAssignedToComposite.setLayout((Layout)new GridLayout(3, false));
        widgetFactory.setBorderStyle(2048);
        this.fAssignedToText = widgetFactory.createText(this.fAssignedToComposite, "");
        this.fAssignedToText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fAssignedToText.setEditable(false);
        this.fAssignedToButton = widgetFactory.createButton(this.fAssignedToComposite, "Add...", 0);
        this.fAssignedToButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fAssignedToButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ((R4EUIContent)ContentsTabPropertySection.this.fProperties.getElement()).addAssignees(UIUtils.getAssignParticipants());
                ContentsTabPropertySection.this.refresh();
                R4EUIModelController.getNavigatorView().getTreeViewer().refresh();
            }
        });
        this.fUnassignedFromButton = widgetFactory.createButton(this.fAssignedToComposite, "Remove...", 0);
        this.fUnassignedFromButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fUnassignedFromButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ((R4EUIContent)ContentsTabPropertySection.this.fProperties.getElement()).removeAssignees(UIUtils.getUnassignParticipants(ContentsTabPropertySection.this.fProperties.getElement()));
                ContentsTabPropertySection.this.refresh();
                R4EUIModelController.getNavigatorView().getTreeViewer().refresh();
            }
        });
        CLabel assignedToLabel = widgetFactory.createCLabel(composite, "Assigned to: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fAssignedToComposite, -5);
        data.top = new FormAttachment((Control)this.fAssignedToComposite, 0, 0x1000000);
        assignedToLabel.setToolTipText("Participant assigned to Review this element.");
        assignedToLabel.setLayoutData((Object)data);
    }

    public void refresh() {
        R4EUIContent uiContent = (R4EUIContent)this.fProperties.getElement();
        this.fRefreshInProgress = true;
        if (uiContent.getPosition() != null) {
            this.fPositionText.setText(uiContent.getPosition().toString());
        } else {
            this.fPositionText.setText("");
        }
        EList assignedParticipants = uiContent.getContent().getAssignedTo();
        this.fAssignedToText.setText(UIUtils.formatAssignedParticipants((EList<String>)assignedParticipants));
        this.setEnabledFields();
        this.fRefreshInProgress = false;
    }

    protected void setEnabledFields() {
        if (R4EUIModelController.isJobInProgress() || this.fProperties.getElement().isReadOnly() || !this.fProperties.getElement().isEnabled() || R4EUIModelController.getActiveReview() == null || ((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED)) {
            this.fPositionText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fAssignedToText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fAssignedToButton.setEnabled(false);
            this.fUnassignedFromButton.setEnabled(false);
        } else {
            this.fPositionText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fAssignedToText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fAssignedToButton.setEnabled(true);
            if (this.fAssignedToText.getText().length() > 0) {
                this.fUnassignedFromButton.setEnabled(true);
            } else {
                this.fUnassignedFromButton.setEnabled(false);
            }
        }
    }
}

