/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.upgrade.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class SimpleFileConverter
extends Job {
    public static final String LINE_FEED = System.getProperty("line.separator");
    BufferedWriter fLogWriter;
    int fFilesConverted;
    int fLinesConverted;
    private final String fExtension;
    private Pattern[] fPatterns;
    private final Replacement[] fReplacements;
    private URI fRootUri;
    private final String[] fIgnoreExtensions;
    private IProgressMonitor fMonitor;
    private boolean fRecurse;

    private SimpleFileConverter(String aExtension, String[] aIgnoreExtensions, Replacement[] aReplacements, boolean aRecurse) {
        super("Convert " + aExtension + " files.");
        this.fExtension = aExtension;
        this.fIgnoreExtensions = aIgnoreExtensions;
        this.fReplacements = aReplacements;
        this.fRecurse = aRecurse;
    }

    public SimpleFileConverter(EObject aParent, String aExtension, String[] aIgnoreExtensions, Replacement[] aReplacements, boolean aRecurse) {
        this(aExtension, aIgnoreExtensions, aReplacements, aRecurse);
        this.fRootUri = aParent.eResource().getURI().trimSegments(1);
    }

    public SimpleFileConverter(URI aUri, String aExtension, String[] aIgnoreExtensions, Replacement[] aReplacements, boolean aRecurse) {
        this(aExtension, aIgnoreExtensions, aReplacements, aRecurse);
        this.fRootUri = aUri;
    }

    protected IStatus run(IProgressMonitor aMonitor) {
        this.fMonitor = aMonitor;
        this.fPatterns = new Pattern[this.fReplacements.length];
        int i = 0;
        while (i < this.fPatterns.length) {
            this.fPatterns[i] = Pattern.compile(this.fReplacements[i].getMatch());
            ++i;
        }
        String filePath = this.fRootUri.toFileString();
        File file = new File(filePath);
        String folderPath = file.isDirectory() ? filePath : file.getParent();
        aMonitor.beginTask("Converting Files", this.count(file));
        File logFile = new File(String.valueOf(folderPath) + File.separator + "conversion.log");
        try {
            logFile.createNewFile();
            this.fLogWriter = new BufferedWriter(new FileWriter(logFile));
            this.log("R4E Common Model Conversion Log: " + logFile.getAbsolutePath() + LINE_FEED + LINE_FEED);
            this.log("Root Folder: " + folderPath);
            this.convert(file);
            this.fLogWriter.close();
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.mylyn.reviews.r4e.core", "Couldn't convert model at URI: " + file, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    protected void convert(File aFile) throws FileNotFoundException, IOException {
        Path path = new Path(aFile.getAbsolutePath());
        if (!aFile.isDirectory() && path.getFileExtension() == null) {
            return;
        }
        Object[] objectArray = this.fIgnoreExtensions;
        int n = this.fIgnoreExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = objectArray[n2];
            if (StringUtils.equals((String)ext, (String)path.getFileExtension())) {
                return;
            }
            ++n2;
        }
        if (aFile.exists()) {
            if (aFile.isDirectory()) {
                objectArray = aFile.listFiles();
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    Object member = objectArray[n2];
                    if (this.fRecurse || !aFile.isDirectory()) {
                        this.convert((File)member);
                    }
                    ++n2;
                }
            } else {
                if (path.getFileExtension() == null) {
                    return;
                }
                if (path.getFileExtension().equals(this.fExtension)) {
                    this.log(String.valueOf(LINE_FEED) + "    " + aFile.getAbsolutePath());
                    ++this.fFilesConverted;
                    BufferedReader br = new BufferedReader(new FileReader(aFile));
                    StringBuilder fileContents = new StringBuilder(8000);
                    int lineNum = 0;
                    while (br.ready()) {
                        String line = br.readLine();
                        String convert = this.convert(line);
                        fileContents.append(String.valueOf(convert) + LINE_FEED);
                        if (!line.equals(convert)) {
                            String lineNumString = StringUtils.leftPad((String)String.valueOf(lineNum), (int)5);
                            this.log("      " + lineNumString + ":  " + line + LINE_FEED + "              " + convert);
                        }
                        ++lineNum;
                    }
                    br.close();
                    BufferedWriter writer = new BufferedWriter(new FileWriter(aFile));
                    writer.write(fileContents.toString());
                    writer.close();
                }
            }
        }
        this.fMonitor.worked(1);
    }

    private String convert(String aLine) {
        String result = aLine;
        int i = 0;
        while (i < this.fPatterns.length) {
            Matcher matcher = this.fPatterns[i].matcher(result);
            result = matcher.replaceAll(this.fReplacements[i].getReplace());
            ++i;
        }
        return result;
    }

    protected int count(File aFile) {
        int count = 0;
        Path path = new Path(aFile.getAbsolutePath());
        if (!aFile.isDirectory() && path.getFileExtension() == null) {
            return 0;
        }
        Object[] objectArray = this.fIgnoreExtensions;
        int n = this.fIgnoreExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = objectArray[n2];
            if (StringUtils.equals((String)ext, (String)path.getFileExtension())) {
                return 0;
            }
            ++n2;
        }
        if (aFile.exists()) {
            ++count;
            if (aFile.isDirectory()) {
                objectArray = aFile.listFiles();
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    Object member = objectArray[n2];
                    count += this.count((File)member);
                    ++n2;
                }
            }
        }
        return count;
    }

    private void log(String aItem) {
        System.out.println(aItem);
        try {
            this.fLogWriter.write(String.valueOf(aItem) + LINE_FEED);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Replacement {
        String fMatch;
        String fReplace;

        public Replacement(String aMatch, String aReplace) {
            this.fMatch = aMatch;
            this.fReplace = aReplace;
        }

        public String getMatch() {
            return this.fMatch;
        }

        public String getReplace() {
            return this.fReplace;
        }
    }
}

