/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.protocol.diagram;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.tesla.core.protocol.BasicUIElement;
import org.eclipse.rcptt.tesla.core.protocol.Children;
import org.eclipse.rcptt.tesla.core.protocol.ChildrenResponse;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GetText;
import org.eclipse.rcptt.tesla.core.protocol.GetTextResponse;
import org.eclipse.rcptt.tesla.core.protocol.IUIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.Parent;
import org.eclipse.rcptt.tesla.core.protocol.ParentResponse;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.SelectResponse;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.UISelector;
import org.eclipse.rcptt.tesla.core.protocol.diagram.ActivateDirectEdit;
import org.eclipse.rcptt.tesla.core.protocol.diagram.CancelDirectEdit;
import org.eclipse.rcptt.tesla.core.protocol.diagram.CommitDirectEdit;
import org.eclipse.rcptt.tesla.core.protocol.diagram.CreateConnection;
import org.eclipse.rcptt.tesla.core.protocol.diagram.CreateConnectionResponse;
import org.eclipse.rcptt.tesla.core.protocol.diagram.CreateFigure;
import org.eclipse.rcptt.tesla.core.protocol.diagram.CreateFigureResponse;
import org.eclipse.rcptt.tesla.core.protocol.diagram.DiagramFactory;
import org.eclipse.rcptt.tesla.core.protocol.diagram.DiagramViewerUIElement;
import org.eclipse.rcptt.tesla.core.protocol.diagram.DirectEditUIElement;
import org.eclipse.rcptt.tesla.core.protocol.diagram.FigureMouseCommand;
import org.eclipse.rcptt.tesla.core.protocol.diagram.MouseCommandKind;
import org.eclipse.rcptt.tesla.core.protocol.diagram.MoveFigure;
import org.eclipse.rcptt.tesla.core.protocol.diagram.ResizeFigure;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.core.protocol.raw.ResponseStatus;

public class FigureUIElement
extends BasicUIElement {
    private final Selectors selector = new Selectors();

    public FigureUIElement(Element e, UIPlayer player) {
        super(e, player);
        this.selector.childFigure = new UISelector<FigureUIElement>(ElementKind.DiagramFigure, (IUIPlayer)player, FigureUIElement.class).parent(this.getElement());
        this.selector.paletteEntry = new UISelector<FigureUIElement>(ElementKind.PaletteEntry, (IUIPlayer)player, FigureUIElement.class).parent(this.getElement());
    }

    public FigureUIElement getParent() {
        Parent command = this.factory.createParent();
        command.setElement(this.getElement());
        Response response = this.player.safeExecuteCommand(command);
        this.player.clearFailures();
        if (response == null) {
            return null;
        }
        ParentResponse parentResponse = (ParentResponse)response;
        Element parent = parentResponse.getParent();
        if (parent.getKind().equals(ElementKind.DiagramFigure.name())) {
            return new FigureUIElement(parent, this.player);
        }
        return null;
    }

    public DiagramViewerUIElement getDiagram() {
        Parent command = this.factory.createParent();
        command.setElement(this.getElement());
        Response response = this.player.safeExecuteCommand(command);
        this.player.clearFailures();
        if (response == null) {
            return null;
        }
        ParentResponse parentResponse = (ParentResponse)response;
        Element parent = parentResponse.getParent();
        if (parent.getKind().equals(ElementKind.DiagramViewer.name())) {
            return new DiagramViewerUIElement(parent, this.player);
        }
        return null;
    }

    public FigureUIElement createFigure(String pattern, int x, int y) {
        CreateFigure figure = DiagramFactory.eINSTANCE.createCreateFigure();
        figure.setPattern(pattern);
        figure.setElement(this.getElement());
        figure.setX(x);
        figure.setY(y);
        Response response = this.player.safeExecuteCommand(figure);
        this.player.clearFailures();
        if (response != null && response.getStatus().equals((Object)ResponseStatus.OK)) {
            CreateFigureResponse figureResponse = (CreateFigureResponse)response;
            EList<Element> list = figureResponse.getFigure();
            if (list.size() != 1) {
                return null;
            }
            return new FigureUIElement((Element)figureResponse.getFigure().get(0), this.player);
        }
        return null;
    }

    public FigureUIElement createConnection(String pattern, FigureUIElement from, FigureUIElement to) {
        CreateConnection figure = DiagramFactory.eINSTANCE.createCreateConnection();
        figure.setPattern(pattern);
        figure.setElement(this.getElement());
        figure.setFrom(from.getElement());
        figure.setTo(to.getElement());
        Response response = this.player.safeExecuteCommand(figure);
        this.player.clearFailures();
        if (response != null && response.getStatus().equals((Object)ResponseStatus.OK)) {
            CreateConnectionResponse figureResponse = (CreateConnectionResponse)response;
            EList<Element> list = figureResponse.getFigure();
            if (list.size() != 1) {
                return null;
            }
            return new FigureUIElement((Element)figureResponse.getFigure().get(0), this.player);
        }
        return null;
    }

    public FigureUIElement[] getChildren() {
        Children command = ProtocolFactory.eINSTANCE.createChildren();
        command.setElement(this.getElement());
        Response response = this.player.safeExecuteCommand(command);
        this.player.clearFailures();
        if (response == null) {
            return null;
        }
        ChildrenResponse childrenResponse = (ChildrenResponse)response;
        EList<Element> children = childrenResponse.getChildren();
        ArrayList<FigureUIElement> figures = new ArrayList<FigureUIElement>();
        for (Element element : children) {
            figures.add(new FigureUIElement(element, this.player));
        }
        return figures.toArray(new FigureUIElement[figures.size()]);
    }

    public FigureUIElement child(String pattern) {
        return this.selector.childFigure.find(pattern);
    }

    public FigureUIElement paletteEntry(String pattern) {
        return this.selector.paletteEntry.find(pattern);
    }

    public FigureUIElement paletteEntry(String pattern, int index) {
        return this.selector.paletteEntry.find(pattern, index);
    }

    public FigureUIElement childClass(String pattern) {
        return this.selector.childFigure.classPattern(pattern).find();
    }

    public DirectEditUIElement directEdit() {
        ActivateDirectEdit cmd = DiagramFactory.eINSTANCE.createActivateDirectEdit();
        cmd.setElement(this.getElement());
        SelectResponse response = (SelectResponse)this.player.safeExecuteCommand(cmd);
        EList<Element> elements = response.getElements();
        if (elements.size() != 1) {
            return null;
        }
        return new DirectEditUIElement((Element)elements.get(0), this.player);
    }

    public void forceDirectEdit(List<Integer> address) {
        ActivateDirectEdit cmd = DiagramFactory.eINSTANCE.createActivateDirectEdit();
        cmd.setElement(this.getElement());
        if (address != null) {
            cmd.getPartPath().addAll(address);
        }
        this.player.safeExecuteCommand(cmd);
    }

    public void deselectAll() {
    }

    public void move(int x, int y) {
        MoveFigure command = DiagramFactory.eINSTANCE.createMoveFigure();
        command.setX(x);
        command.setY(y);
        command.setElement(this.getElement());
        this.player.safeExecuteCommand(command);
    }

    public void resize(int width, int height) {
        ResizeFigure command = DiagramFactory.eINSTANCE.createResizeFigure();
        command.setX(width);
        command.setY(height);
        command.setElement(this.getElement());
        this.player.safeExecuteCommand(command);
    }

    public String getText() {
        GetText cmd = this.factory.createGetText();
        cmd.setElement(this.getElement());
        GetTextResponse response = (GetTextResponse)this.player.safeExecuteCommand(cmd);
        this.player.clearFailures();
        if (response == null) {
            return null;
        }
        if (response.getStatus().equals((Object)ResponseStatus.OK)) {
            return response.getText();
        }
        return null;
    }

    public void executeFigureMouseCommand(int x, int y, int button, MouseCommandKind kind, List<Integer> partPath, List<Integer> figurePath, int width, int height, int figureWidth, int figureHeight, int stateMask) {
        FigureMouseCommand command = DiagramFactory.eINSTANCE.createFigureMouseCommand();
        command.setKind(kind);
        command.setButton(button);
        command.setElement(this.getElement());
        command.setX(x);
        command.setY(y);
        command.setBoundsWidth(width);
        command.setBoundsHeight(height);
        command.setFigureHeight(figureHeight);
        command.setFigureWidth(figureWidth);
        command.setStateMask(stateMask);
        if (figurePath != null) {
            command.getFigurePath().addAll(figurePath);
        }
        if (partPath != null) {
            command.getPartPath().addAll(partPath);
        }
        this.player.safeExecuteCommand(command);
    }

    public void cancelDirectEdit() {
        CancelDirectEdit cmd = DiagramFactory.eINSTANCE.createCancelDirectEdit();
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public void commitDirectEdit() {
        CommitDirectEdit cmd = DiagramFactory.eINSTANCE.createCommitDirectEdit();
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public void activateDirectEdit(List<Integer> partPaths) {
        ActivateDirectEdit cmd = DiagramFactory.eINSTANCE.createActivateDirectEdit();
        cmd.setElement(this.getElement());
        if (partPaths != null) {
            cmd.getPartPath().addAll(partPaths);
        }
        this.player.safeExecuteCommand(cmd);
    }

    public FigureUIElement figure(List<Integer> address) {
        return this.selector.childFigure.path("editpart", "address").indexes(address.toArray(new Integer[address.size()])).find();
    }

    public FigureUIElement figure(Integer ... address) {
        return this.selector.childFigure.path("editpart", "address").indexes(address).find();
    }

    public FigureUIElement figureSourceConnection(int connection) {
        return this.selector.childFigure.path("editpart.source.connection", "address").indexes(connection).find();
    }

    public FigureUIElement figureTargetConnection(int connection) {
        return this.selector.childFigure.path("editpart.target.connection", "address").indexes(connection).find();
    }

    public FigureUIElement rawFigure(List<Integer> path) {
        return this.selector.childFigure.path("rawFigure", "address").indexes(path.toArray(new Integer[path.size()])).find();
    }

    public FigureUIElement rawFigureAt(int x, int y) {
        return this.selector.childFigure.path("figure", "position", Integer.toString(x), Integer.toString(y)).find();
    }

    public FigureUIElement figureByFeature(String name, String value, Integer index) {
        return this.selector.childFigure.path("editpart.feature", name).find(value, index);
    }

    public FigureUIElement figureByName(String value, Integer index) {
        return this.selector.childFigure.path("editpart", "name").find(value, index);
    }

    public FigureUIElement handleByClass(String value, Integer index) {
        return this.selector.childFigure.path("handle", "class").find(value, index);
    }

    public FigureUIElement figureByText(String value, Integer index) {
        return this.selector.childFigure.path("editpart", "text").find(value, index);
    }

    public FigureUIElement figureByCustomId(String value) {
        return this.selector.childFigure.path("editpart", "customId").find(value);
    }

    public FigureUIElement figureByClassName(String value, Integer index) {
        return this.selector.childFigure.path("editpart", "classname").find(value, index);
    }

    private static class Selectors {
        public UISelector<FigureUIElement> childFigure;
        public UISelector<FigureUIElement> paletteEntry;

        private Selectors() {
        }
    }
}

