/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.ext.OSArchitecture;
import org.eclipse.rcptt.internal.launching.ext.PDELocationUtils;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformManager;
import org.eclipse.rcptt.internal.launching.ext.ui.Activator;
import org.eclipse.rcptt.internal.launching.ext.ui.TimeTriggeredProgressMonitorDialog;
import org.eclipse.rcptt.internal.launching.ext.ui.wizards.UpdateJob;
import org.eclipse.rcptt.launching.Aut;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.AutLaunchState;
import org.eclipse.rcptt.launching.AutManager;
import org.eclipse.rcptt.launching.CheckedExceptionWrapper;
import org.eclipse.rcptt.launching.ext.Q7LaunchDelegateUtils;
import org.eclipse.rcptt.launching.ext.VmInstallMetaData;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.launching.target.TargetPlatformManager;
import org.eclipse.rcptt.ui.WidgetUtils;
import org.eclipse.rcptt.ui.commons.SWTFactory;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class NewAUTPage
extends WizardPage {
    private static final int FIELD_TIMEOUT = 500;
    private static final ILog LOG = Platform.getLog(NewAUTPage.class);
    private DataBindingContext dbc = new DataBindingContext();
    private Shell shell;
    private WritableValue<String> nameValue = new WritableValue((Object)"", String.class);
    private WritableValue<String> locationValue = new WritableValue((Object)"", String.class);
    private WritableValue<ITargetPlatformHelper> info = new WritableValue(null, ITargetPlatformHelper.class);
    private WritableValue<Boolean> architectureError = new WritableValue((Object)Boolean.FALSE, Boolean.class);
    private WritableValue<Boolean> showAdvanced = new WritableValue((Object)Boolean.FALSE, Boolean.class);
    private WritableValue<String> warningMessageValue = new WritableValue((Object)"", String.class);
    private WritableValue<Boolean> autolaunchValue = new WritableValue((Object)Boolean.FALSE, Boolean.class);
    private WritableValue<String> autolaunchLabel = new WritableValue((Object)"Launch AUT", String.class);
    private String currentName = null;
    private Runnable advancedHandler;
    private final UpdateJob<State> updateJob = new UpdateJob<State>("Validating AUT"){
        {
            this.setUser(true);
        }

        public boolean shouldSchedule() {
            if (super.shouldSchedule()) {
                NewAUTPage.this.setStatus(NewAUTPage.this.cancel("Validating..."), false);
                return true;
            }
            return false;
        }

        @Override
        protected void run(State input, IProgressMonitor monitor) {
            NewAUTPage.this.setStatus(NewAUTPage.this.validate(input, monitor));
        }
    };

    protected NewAUTPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    void setStatus(IStatus status) {
        this.setStatus(status, true);
    }

    void setStatus(IStatus status, boolean logging) {
        if (!status.isOK() && !status.matches(8) && logging) {
            Q7ExtLaunchingPlugin.log((IStatus)status);
        }
        this.asyncExec(() -> {
            if (status.matches(8)) {
                this.setMessage(status.getMessage());
                this.setErrorMessage(null);
                this.setPageComplete(false);
            } else if (status.matches(4)) {
                this.setMessage(null);
                this.setErrorMessage(status.getMessage());
                this.setPageComplete(false);
            } else if (status.isOK()) {
                this.setMessage(null);
                this.setErrorMessage(null);
                this.setPageComplete(true);
            } else {
                this.setMessage(status.getMessage());
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
        });
    }

    private State getState() {
        return new State((String)this.locationValue.getValue(), (ITargetPlatformHelper)this.info.getValue(), (String)this.nameValue.getValue());
    }

    private IStatus cancel(String message) {
        return new Status(8, ((Object)((Object)this)).getClass(), message);
    }

    private IStatus validate(State state, IProgressMonitor monitor) {
        String location = state.location;
        if (location == null || location.trim().length() == 0) {
            return this.cancel("Please specify your Eclipse application installation directory.");
        }
        ITargetPlatformHelper helper = state.target();
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            IStatus status;
            if (helper == null) {
                TargetPlatformManager.clearTargets();
                status = this.checkLocationExists(location);
                if (status.matches(12)) {
                    IStatus iStatus = status;
                    return iStatus;
                }
                ITargetPlatformHelper platform = null;
                platform = Q7TargetPlatformManager.createTargetPlatform((String)location, (IProgressMonitor)sm.split(1, 0));
                status = platform.getStatus();
                if (status.matches(12)) {
                    platform.delete();
                    IStatus iStatus = status;
                    return iStatus;
                }
                helper = platform;
            }
            if ((status = this.validatePlatform(helper, (IProgressMonitor)sm.split(1, 0))).matches(12)) {
                helper.delete();
                IStatus iStatus = status;
                return iStatus;
            }
            this.setValue(helper, this.info);
            IStatus iStatus = this.validateAUTName(state.name, helper.getDefaultProduct());
            return iStatus;
        }
        catch (CoreException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            IProgressMonitor.done((IProgressMonitor)monitor);
        }
    }

    private void clean() {
        ITargetPlatformHelper helper = (ITargetPlatformHelper)this.info.getValue();
        this.info.setValue(null);
        if (helper != null) {
            helper.delete();
        }
    }

    protected static void throwIfError(IStatus status) throws CoreException {
        if (status.matches(12)) {
            throw new CoreException(status);
        }
    }

    protected IStatus checkLocationExists(String location) {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            location = manager.performStringSubstitution(location);
            return PDELocationUtils.validateProductLocation((String)location);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    private IStatus validatePlatform(ITargetPlatformHelper helper, IProgressMonitor monitor) {
        if (helper == null) {
            return this.cancel("Please specify correct Application installation directory...");
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IStatus status = helper.resolve((IProgressMonitor)sm.split(1, 0));
        if (status.matches(12)) {
            return status;
        }
        OSArchitecture architecture = helper.detectArchitecture(new StringBuilder());
        if (OSArchitecture.Unknown.equals((Object)architecture)) {
            return Status.error((String)"Unable to detect AUT's architecture.");
        }
        boolean haveArch = false;
        try {
            haveArch = this.findJVM(helper).isPresent();
        }
        catch (CoreException e1) {
            return e1.getStatus();
        }
        this.setValue(!haveArch, this.architectureError);
        if (!haveArch) {
            return Status.error((String)("The selected AUT requires " + String.valueOf(architecture) + " Java VM which cannot be found."));
        }
        try {
            IStatus iStatus = Q7LaunchDelegateUtils.validateForLaunch((ITargetPlatformHelper)helper, (IProgressMonitor)sm.split(1, 0));
            return iStatus;
        }
        finally {
            IProgressMonitor.done((IProgressMonitor)monitor);
        }
    }

    private Optional<VmInstallMetaData> findJVM(ITargetPlatformHelper helper) throws CoreException {
        StringBuilder message = new StringBuilder();
        OSArchitecture arch = helper.detectArchitecture(message);
        if (OSArchitecture.Unknown.equals((Object)arch)) {
            throw new CoreException(Status.error((String)("Unable to detect AUT's architecture: " + message.toString())));
        }
        return VmInstallMetaData.all().filter(m -> m.arch.equals((Object)arch)).filter(m -> this.isCompatible(helper, (VmInstallMetaData)m)).findFirst();
    }

    private boolean isCompatible(ITargetPlatformHelper helper, VmInstallMetaData m) {
        return Collections.disjoint(m.compatibleEnvironments, helper.getIncompatibleExecutionEnvironments());
    }

    private String computeUniqueName(String prefix) throws CoreException {
        Set<String> existingNames = this.existingNames();
        int i = 2;
        Object name = prefix;
        while (existingNames.contains(name)) {
            name = prefix + Integer.toString(i++);
        }
        return name;
    }

    private Set<String> existingNames() throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.eclipse.rcptt.launching.ext");
        Set<String> existingNames = Arrays.stream(launchManager.getLaunchConfigurations(type)).map(ILaunchConfiguration::getName).filter(Predicate.not(Predicate.isEqual(this.currentName))).collect(Collectors.toSet());
        return existingNames;
    }

    private IStatus validateAUTName(String name, String defaultName) {
        if (name.trim().length() == 0 && defaultName != null) {
            try {
                name = this.computeUniqueName(defaultName);
                this.setValue(name, this.nameValue);
            }
            catch (CoreException e) {
                LOG.log(e.getStatus());
            }
        }
        if (name.length() == 0) {
            return Status.error((String)"The name of Application Under Test (AUT) can not be empty.");
        }
        char[] cArray = name.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (FileUtil.isInvalidFileNameChar((char)c)) {
                return Status.error((String)("Symbol \"" + c + "\" is not acceptable in an AUT name."));
            }
            ++n2;
        }
        try {
            if (this.existingNames().contains(name)) {
                return Status.error((String)MessageFormat.format("Application {0} already exists. Please specify a different name.", name));
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    public void createControl(Composite sparent) {
        this.initializeDialogUnits((Control)sparent);
        this.shell = sparent.getShell();
        Composite parent = new Composite(sparent, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.createControlLocation(parent);
        this.createControlName(parent);
        this.createControlArch(parent);
        this.createControlAdvanced(parent);
        this.createControlAutolaunch(parent);
        this.createControlWarning(parent);
        IChangeListener validatePlatformListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                NewAUTPage.this.updateJob.update(NewAUTPage.this.getState());
            }
        };
        this.info.addChangeListener(validatePlatformListener);
        this.setControl((Control)parent);
        if (this.info.getValue() == null) {
            this.clean();
        }
        this.updateJob.update(this.getState());
        parent.addDisposeListener(ignored -> {
            boolean bl = this.updateJob.cancel();
        });
        Dialog.applyDialogFont((Control)parent);
    }

    private void createControlLocation(Composite parent) {
        Label locationLabel = new Label(parent, 0);
        locationLabel.setText("Location:");
        Text locationField = new Text(parent, 2048);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).hint(200, -1).applyTo((Control)locationField);
        ISWTObservableValue locationModifyObservable = WidgetProperties.text((int)24).observe((Widget)locationField);
        locationModifyObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                NewAUTPage.this.setPageComplete(false);
            }
        });
        this.dbc.bindValue(Observables.observeDelayedValue((int)500, (IObservableValue)locationModifyObservable), this.locationValue);
        this.locationValue.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                NewAUTPage.this.clean();
                NewAUTPage.this.updateJob.update(NewAUTPage.this.getState());
            }
        });
        Button fileLocationButton = new Button(parent, 8);
        fileLocationButton.setText("&Browse...");
        fileLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewAUTPage.this.handleSelectLocation();
            }
        });
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)fileLocationButton);
        SWTFactory.setButtonDimensionHint((Button)fileLocationButton);
    }

    private void createControlName(Composite parent) {
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText("Name:");
        Text nameField = new Text(parent, 2048);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).hint(200, -1).span(2, 1).applyTo((Control)nameField);
        ISWTObservableValue nameModifyObservable = WidgetProperties.text((int)24).observe((Widget)nameField);
        nameModifyObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                NewAUTPage.this.setPageComplete(false);
            }
        });
        this.dbc.bindValue(Observables.observeDelayedValue((int)500, (IObservableValue)nameModifyObservable), this.nameValue);
        this.nameValue.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                NewAUTPage.this.updateJob.update(NewAUTPage.this.getState());
            }
        });
    }

    private void createControlArch(final Composite parent) {
        final Link archLink = new Link(parent, 4);
        archLink.setText("There is no appropriate JVM configured. <a>Configure JVM...</a>");
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)archLink);
        archLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)NewAUTPage.this.shell, (String)"org.eclipse.jdt.debug.ui.preferences.VMPreferencePage", (String[])new String[]{"org.eclipse.jdt.debug.ui.preferences.VMPreferencePage"}, null);
                if (dialog.open() == 0) {
                    NewAUTPage.this.updateJob.update(NewAUTPage.this.getState());
                }
            }
        });
        ISWTObservableValue archLinkObservable = WidgetProperties.visible().observe((Widget)archLink);
        archLinkObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                GridData data = (GridData)archLink.getLayoutData();
                data.exclude = !archLink.getVisible();
                parent.layout(false);
            }
        });
        this.dbc.bindValue((IObservableValue)archLinkObservable, this.architectureError);
    }

    private void createControlAdvanced(Composite parent) {
        Link advanced = new Link(parent, 4);
        advanced.setText("<a>Advanced...</a>");
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)advanced);
        advanced.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewAUTPage.this.advancedHandler != null) {
                    NewAUTPage.this.advancedHandler.run();
                }
            }
        });
        this.dbc.bindValue((IObservableValue)WidgetProperties.visible().observe((Widget)advanced), this.showAdvanced);
    }

    private void createControlAutolaunch(Composite parent) {
        Button autolaunch = new Button(parent, 32);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)autolaunch);
        autolaunch.setText("to del");
        autolaunch.setSelection(true);
        this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)autolaunch), this.autolaunchValue);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)autolaunch), this.autolaunchLabel);
    }

    private void createControlWarning(final Composite parent) {
        Label warning = new Label(parent, 64);
        warning.setText("");
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)warning);
        ISWTObservableValue warningObservable = WidgetProperties.text().observe((Widget)warning);
        warningObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                parent.layout(false);
            }
        });
        this.dbc.bindValue((IObservableValue)warningObservable, this.warningMessageValue);
    }

    protected void handleSelectLocation() {
        DirectoryDialog fileDialog = new DirectoryDialog(this.shell, 0);
        fileDialog.setFilterPath((String)this.locationValue.getValue());
        String text = fileDialog.open();
        if (text != null) {
            this.locationValue.setValue((Object)text);
        }
    }

    public ITargetPlatformHelper getTarget() {
        return (ITargetPlatformHelper)this.info.getValue();
    }

    public String getTargetName() {
        return (String)this.nameValue.getValue();
    }

    public String getTargetLocation() {
        return (String)this.locationValue.getValue();
    }

    public IVMInstall getJVMInstall() throws CoreException {
        try {
            return Optional.ofNullable((ITargetPlatformHelper)this.info.getValue()).flatMap(CheckedExceptionWrapper.wrap(this::findJVM)).map(m -> m.install).orElse(null);
        }
        catch (CheckedExceptionWrapper e) {
            e.rethrow(CoreException.class);
            throw e;
        }
    }

    public OSArchitecture getJVMArch() throws CoreException {
        try {
            return Optional.ofNullable((ITargetPlatformHelper)this.info.getValue()).flatMap(CheckedExceptionWrapper.wrap(this::findJVM)).map(m -> m.arch).orElse(null);
        }
        catch (CheckedExceptionWrapper e) {
            e.rethrow(CoreException.class);
            throw e;
        }
    }

    public Boolean isLaunchNeeded() {
        return (Boolean)this.autolaunchValue.getValue();
    }

    public OSArchitecture getArchitecture() throws CoreException {
        StringBuilder message = new StringBuilder();
        ITargetPlatformHelper helper = (ITargetPlatformHelper)this.info.getValue();
        if (helper == null) {
            throw new CoreException(Status.error((String)"AUT is not configured yet"));
        }
        OSArchitecture arch = helper.detectArchitecture(message);
        if (OSArchitecture.Unknown.equals((Object)arch)) {
            throw new CoreException(Status.error((String)("Unable to detect AUT's architecture: " + message.toString())));
        }
        return arch;
    }

    public void initializeExisting(String configName, String autLocation, final ILaunchConfiguration configuration) {
        Aut launch;
        this.currentName = configName;
        final ITargetPlatformHelper[] helper = new ITargetPlatformHelper[1];
        TimeTriggeredProgressMonitorDialog dialog = new TimeTriggeredProgressMonitorDialog(this.shell, 500);
        try {
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        helper[0] = Q7TargetPlatformManager.findTarget((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
                    }
                    catch (CoreException e) {
                        RcpttPlugin.log((Throwable)e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.log(e);
        }
        catch (InterruptedException e) {
            Activator.log(e);
        }
        if (helper[0] != null && helper[0].getStatus().isOK()) {
            this.info.setValue((Object)helper[0]);
        }
        this.nameValue.setValue((Object)configName);
        this.locationValue.setValue((Object)autLocation);
        Boolean isAutLaunched = false;
        if (configuration != null && (launch = AutManager.INSTANCE.getByLaunch(configuration)) != null) {
            List list = launch.getLaunches();
            for (AutLaunch autLaunch : list) {
                if (!autLaunch.getState().equals((Object)AutLaunchState.ACTIVE)) continue;
                this.warningMessageValue.setValue((Object)"Running AUT is detected.\nPlease restart AUT manually, after configuration update, if required.");
                isAutLaunched = true;
                break;
            }
        }
        if (isAutLaunched.booleanValue()) {
            this.autolaunchLabel.setValue((Object)"Restart AUT");
        } else {
            this.autolaunchLabel.setValue((Object)"Launch AUT");
        }
    }

    private <T> void setValue(T value, WritableValue<T> destination) {
        destination.getRealm().exec(() -> destination.setValue(value));
    }

    public void addAdvancedHandler(Runnable runnable) {
        this.showAdvanced.setValue((Object)Boolean.TRUE);
        this.advancedHandler = runnable;
    }

    private void asyncExec(Runnable runnable) {
        WidgetUtils.asyncExec((Widget)this.getControl(), (Runnable)runnable);
    }

    private record State(String location, ITargetPlatformHelper target, String name) {
    }
}

