/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.actions.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7ElementVisitor;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.ReferencedProjectScope;
import org.eclipse.rcptt.internal.core.model.index.NamedElementCollector;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.actions.RenameDialog;
import org.eclipse.rcptt.ui.actions.edit.Q7CopyFilesAndFoldersOperation;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.rcptt.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.rcptt.ui.utils.WriteAccessChecker;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.ide.undo.AbstractWorkspaceOperation;
import org.eclipse.ui.ide.undo.CopyResourcesOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.part.ResourceTransfer;

public class PasteAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.PasteAction";
    private final Shell shell;
    private final Clipboard clipboard;

    public PasteAction(Shell shell, Clipboard clipboard) {
        super(Messages.PasteAction_Text);
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)clipboard);
        this.shell = shell;
        this.clipboard = clipboard;
        this.setToolTipText(Messages.PasteAction_ToolTip);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "HelpId");
    }

    private IResource getTarget() {
        List selectedResources = this.getSelectedResources();
        int i = 0;
        while (i < selectedResources.size()) {
            IResource resource = (IResource)selectedResources.get(i);
            if (resource instanceof IProject && !((IProject)resource).isOpen()) {
                return null;
            }
            if (resource.getType() == 1) {
                resource = resource.getParent();
            }
            if (resource != null) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    private boolean isLinked(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i].isLinked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void run() {
        if (LaunchUtils.hasLaunchedTestCases()) {
            MessageDialog.openWarning((Shell)this.shell, (String)Messages.PasteAction_ErrorDialogTitle, (String)Messages.PasteAction_ErrorDialogMsg);
            return;
        }
        if (!RefactoringSaveHelper.checkDirtyEditors(this.shell)) {
            return;
        }
        ResourceTransfer resTransfer = ResourceTransfer.getInstance();
        IResource[] resourceData = (IResource[])this.clipboard.getContents((Transfer)resTransfer);
        if (resourceData != null && resourceData.length > 0) {
            if (resourceData[0].getType() == 4) {
                int i = 0;
                while (i < resourceData.length) {
                    CopyProjectOperation operation = new CopyProjectOperation(this.shell);
                    operation.copyProject((IProject)resourceData[i]);
                    ++i;
                }
            } else {
                IContainer container = this.getContainer();
                try {
                    WriteAccessChecker writeAccessChecker = new WriteAccessChecker(this.shell);
                    if (!writeAccessChecker.makeResourceWritable(new IResource[]{container})) {
                        return;
                    }
                }
                catch (CoreException e) {
                    Q7UIPlugin.log(e);
                }
                final ArrayList<IQ7NamedElement> namedElements = new ArrayList<IQ7NamedElement>();
                ArrayList<IResource> normalResources = new ArrayList<IResource>();
                IResource[] iResourceArray = resourceData;
                int n = resourceData.length;
                int n2 = 0;
                while (n2 < n) {
                    IQ7NamedElement namedElement;
                    IResource resource = iResourceArray[n2];
                    if (resource instanceof IFile && (namedElement = (IQ7NamedElement)RcpttCore.create((IResource)((IFile)resource))) != null) {
                        namedElements.add(namedElement);
                    } else {
                        normalResources.add(resource);
                    }
                    ++n2;
                }
                IQ7NamedElement[] elements = namedElements.toArray(new IQ7NamedElement[namedElements.size()]);
                Map map = RcpttCore.getInstance().getCopyDestinationMap(elements, container);
                if (normalResources.size() > 0) {
                    Q7CopyFilesAndFoldersOperation operation = new Q7CopyFilesAndFoldersOperation(this.shell){

                        @Override
                        protected AbstractWorkspaceOperation getUndoableCopyOrMoveOperation(IResource[] resources, boolean renamed, IPath ... destinationPath) {
                            if (renamed) {
                                return new Q7ResourceCopyOperation(resources, destinationPath, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_copyTitle, namedElements);
                            }
                            ArrayList<IPath> dests = new ArrayList<IPath>();
                            IResource[] iResourceArray = resources;
                            int n = resources.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IResource res = iResourceArray[n2];
                                dests.add(destinationPath[0].append(res.getName()));
                                ++n2;
                            }
                            return new Q7ResourceCopyOperation(resources, destinationPath[0], IDEWorkbenchMessages.CopyFilesAndFoldersOperation_copyTitle, namedElements, dests.toArray(new IPath[dests.size()]));
                        }
                    };
                    IResource[] result = operation.copyResources(normalResources.toArray(new IResource[normalResources.size()]), container);
                    if (result.length == 0) {
                        return;
                    }
                    if (namedElements.size() != elements.length) {
                        elements = namedElements.toArray(new IQ7NamedElement[namedElements.size()]);
                    }
                }
                HashMap<IQ7NamedElement, String> newNames = new HashMap<IQ7NamedElement, String>();
                Set<String> names = this.CollectNames(container);
                HashSet<IPath> filesSkip = new HashSet<IPath>();
                ArrayList<IQ7NamedElement> skipElements = new ArrayList<IQ7NamedElement>();
                boolean isSameDestination = this.isDestinationSameAsSource(resourceData, container);
                int overwrite = 3;
                IWorkspaceRoot workspaceRoot = container.getWorkspace().getRoot();
                for (Map.Entry e : map.entrySet()) {
                    IResource destination;
                    if (!((IFile)e.getValue()).exists()) continue;
                    if (isSameDestination) {
                        try {
                            RenameDialog dialog = new RenameDialog(this.shell, ((IQ7NamedElement)e.getKey()).getElementName(), names, (IFile)e.getValue(), Messages.PasteAction_DialogTitle, filesSkip, Messages.PasteAction_DialogNewNameProposal);
                            if (dialog.open() == 0) {
                                newNames.put((IQ7NamedElement)e.getKey(), dialog.getResultName());
                                names.add(dialog.getResultName());
                                IPath newFilePath = dialog.getNewFileName();
                                filesSkip.add(newFilePath);
                                map.put((IQ7NamedElement)e.getKey(), ResourcesPlugin.getWorkspace().getRoot().getFile(newFilePath));
                                continue;
                            }
                            return;
                        }
                        catch (ModelException e2) {
                            Q7UIPlugin.log(e2);
                        }
                        continue;
                    }
                    if (overwrite == 4) continue;
                    IResource source = ((IQ7NamedElement)e.getKey()).getResource();
                    overwrite = this.checkOverwrite(source, destination = workspaceRoot.findMember(((IFile)e.getValue()).getFullPath()));
                    if (overwrite == 3) {
                        skipElements.add((IQ7NamedElement)e.getKey());
                    }
                    if (overwrite != 1) continue;
                    return;
                }
                if (skipElements.size() > 0) {
                    for (IQ7NamedElement element : skipElements) {
                        namedElements.remove(element);
                        newNames.remove(element);
                        map.remove(element);
                    }
                    elements = namedElements.toArray(new IQ7NamedElement[namedElements.size()]);
                }
                try {
                    RcpttCore.getInstance().copy(elements, map, newNames);
                }
                catch (CoreException e) {
                    Q7UIPlugin.log(e);
                }
            }
            return;
        }
        FileTransfer fileTransfer = FileTransfer.getInstance();
        String[] fileData = (String[])this.clipboard.getContents((Transfer)fileTransfer);
        if (fileData != null) {
            IContainer container = this.getContainer();
            CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.shell);
            operation.copyFiles(fileData, container);
        }
    }

    private IContainer getContainer() {
        List selection = this.getSelectedResources();
        if (selection.get(0) instanceof IFile) {
            return ((IFile)selection.get(0)).getParent();
        }
        return (IContainer)selection.get(0);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        int i;
        boolean isProjectRes;
        if (!super.updateSelection(selection)) {
            return false;
        }
        final IResource[][] clipboardData = new IResource[1][];
        this.shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ResourceTransfer resTransfer = ResourceTransfer.getInstance();
                clipboardData[0] = (IResource[])PasteAction.this.clipboard.getContents((Transfer)resTransfer);
            }
        });
        IResource[] resourceData = clipboardData[0];
        boolean bl = isProjectRes = resourceData != null && resourceData.length > 0 && resourceData[0].getType() == 4;
        if (isProjectRes) {
            int i2 = 0;
            while (i2 < resourceData.length) {
                if (resourceData[i2].getType() != 4 || !((IProject)resourceData[i2]).isOpen()) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        IResource targetResource = this.getTarget();
        if (targetResource == null) {
            return false;
        }
        List selectedResources = this.getSelectedResources();
        if (selectedResources.size() > 1) {
            i = 0;
            while (i < selectedResources.size()) {
                IResource resource = (IResource)selectedResources.get(i);
                if (resource.getType() != 1) {
                    return false;
                }
                if (!targetResource.equals((Object)resource.getParent())) {
                    return false;
                }
                ++i;
            }
        }
        if (resourceData != null) {
            if (this.isLinked(resourceData) && targetResource.getType() != 4 && targetResource.getType() != 2) {
                return false;
            }
            if (targetResource.getType() == 2) {
                i = 0;
                while (i < resourceData.length) {
                    if (targetResource.equals((Object)resourceData[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        TransferData[] transfers = this.clipboard.getAvailableTypes();
        FileTransfer fileTransfer = FileTransfer.getInstance();
        int i3 = 0;
        while (i3 < transfers.length) {
            if (fileTransfer.isSupportedType(transfers[i3])) {
                return true;
            }
            ++i3;
        }
        return false;
    }

    private Set<String> CollectNames(IContainer container) {
        HashSet<String> names = new HashSet<String>();
        IQ7Project project = RcpttCore.create((IProject)container.getProject());
        names.addAll(Arrays.asList(Q7SearchCore.findAllNames((ISearchScope)new ReferencedProjectScope(project))));
        return names;
    }

    boolean isDestinationSameAsSource(IResource[] sourceResources, IContainer destination) {
        IPath destinationLocation = destination.getLocation();
        int i = 0;
        while (i < sourceResources.length) {
            IResource sourceResource = sourceResources[i];
            if (sourceResource.getParent().equals((Object)destination)) {
                return true;
            }
            if (destinationLocation != null) {
                IPath sourceLocation = sourceResource.getLocation();
                IPath destinationResource = destinationLocation.append(sourceResource.getName());
                if (sourceLocation != null && sourceLocation.isPrefixOf(destinationResource)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private int checkOverwrite(final IResource source, final IResource destination) {
        final int[] result = new int[1];
        Runnable query = new Runnable(){

            @Override
            public void run() {
                int[] resultId = new int[]{2, 4, 3, 1};
                String[] labels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                Object[] bindings = new String[]{IDEResourceInfoUtils.getLocationText((IResource)destination), IDEResourceInfoUtils.getDateStringValue((IResource)destination), IDEResourceInfoUtils.getLocationText((IResource)source), IDEResourceInfoUtils.getDateStringValue((IResource)source)};
                String message = NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteWithDetailsQuestion, (Object[])bindings);
                MessageDialog dialog = new MessageDialog(PasteAction.this.shell, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_resourceExists, null, message, 3, labels, 0){

                    protected int getShellStyle() {
                        return super.getShellStyle() | 0x10000000;
                    }
                };
                dialog.open();
                result[0] = dialog.getReturnCode() == -1 ? 1 : resultId[dialog.getReturnCode()];
            }
        };
        this.shell.getDisplay().syncExec(query);
        return result[0];
    }

    private final class Q7ResourceCopyOperation
    extends CopyResourcesOperation {
        private final List<IQ7NamedElement> namedElements;
        private final IPath[] destinationPath;

        private Q7ResourceCopyOperation(IResource[] resources, IPath[] destinationPaths, String label, List<IQ7NamedElement> namedElements) {
            super(resources, destinationPaths, label);
            this.namedElements = namedElements;
            this.destinationPath = destinationPaths;
        }

        private Q7ResourceCopyOperation(IResource[] resources, IPath destinationPath, String label, List<IQ7NamedElement> namedElements, IPath[] targetPaths) {
            super(resources, destinationPath, label);
            this.namedElements = namedElements;
            this.destinationPath = targetPaths;
        }

        protected void copy(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
            super.copy(monitor, uiInfo);
            try {
                IPath[] iPathArray = this.destinationPath;
                int n = this.destinationPath.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath dest = iPathArray[n2];
                    IQ7Element element = RcpttCore.create((IResource)ResourcesPlugin.getWorkspace().getRoot().findMember(dest));
                    if (element != null && element.exists()) {
                        NamedElementCollector collector = new NamedElementCollector();
                        element.accept((IQ7ElementVisitor)collector);
                        this.namedElements.addAll(collector.getElements());
                    }
                    ++n2;
                }
            }
            catch (InterruptedException e) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
    }
}

