/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.launching.launchConfigurations;

import org.eclipse.ant.internal.launching.AntLaunchingUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationMigrationDelegate;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class AntMigrationDelegate
implements ILaunchConfigurationMigrationDelegate {
    protected IFile getFileForCandidate(ILaunchConfiguration candidate) {
        IFile file = null;
        String expandedLocation = null;
        String location = null;
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            location = candidate.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
            if (location != null && (expandedLocation = manager.performStringSubstitution(location)) != null) {
                file = AntLaunchingUtil.getFileForLocation(expandedLocation, null);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return file;
    }

    public boolean isCandidate(ILaunchConfiguration candidate) throws CoreException {
        IResource[] mappedResources = candidate.getMappedResources();
        if (mappedResources != null && mappedResources.length > 0) {
            return false;
        }
        return this.getFileForCandidate(candidate) != null;
    }

    public void migrate(ILaunchConfiguration candidate) throws CoreException {
        IFile file = this.getFileForCandidate(candidate);
        ILaunchConfigurationWorkingCopy wc = candidate.getWorkingCopy();
        wc.setMappedResources(new IResource[]{file});
        wc.doSave();
    }
}

