/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.persistence.CompositeRepositoryState;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.AbstractApplication;
import org.eclipse.equinox.p2.internal.repository.tools.ArtifactRepositoryValidator;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;

public class CompositeRepositoryApplication
extends AbstractApplication {
    private final List<RepositoryDescriptor> childrenToAdd = new ArrayList<RepositoryDescriptor>();
    private final List<RepositoryDescriptor> childrenToRemove = new ArrayList<RepositoryDescriptor>();
    private boolean removeAllChildren = false;
    private boolean failOnExists = false;
    private String comparatorID = null;

    public CompositeRepositoryApplication() {
    }

    public CompositeRepositoryApplication(IProvisioningAgent agent) {
        super(agent);
    }

    @Override
    public IStatus run(IProgressMonitor monitor) throws ProvisionException {
        try {
            this.initializeRepos((IProgressMonitor)new NullProgressMonitor());
            CompositeMetadataRepository metadataRepo = (CompositeMetadataRepository)this.destinationMetadataRepository;
            CompositeArtifactRepository artifactRepo = (CompositeArtifactRepository)this.destinationArtifactRepository;
            if (this.removeAllChildren) {
                if (artifactRepo != null) {
                    artifactRepo.removeAllChildren();
                }
                if (metadataRepo != null) {
                    metadataRepo.removeAllChildren();
                }
            } else {
                for (RepositoryDescriptor child : this.childrenToRemove) {
                    if (child.isArtifact() && artifactRepo != null) {
                        artifactRepo.removeChild(child.getOriginalRepoLocation());
                    }
                    if (!child.isMetadata() || metadataRepo == null) continue;
                    metadataRepo.removeChild(child.getOriginalRepoLocation());
                }
            }
            for (RepositoryDescriptor child : this.childrenToAdd) {
                if (child.isArtifact() && artifactRepo != null) {
                    artifactRepo.addChild(child.getOriginalRepoLocation());
                }
                if (!child.isMetadata() || metadataRepo == null) continue;
                metadataRepo.addChild(child.getOriginalRepoLocation());
            }
            if (this.comparatorID != null) {
                ArtifactRepositoryValidator validator = new ArtifactRepositoryValidator(this.comparatorID);
                IStatus iStatus = validator.validateComposite(artifactRepo);
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            this.finalizeRepositories();
        }
    }

    public void addChild(RepositoryDescriptor child) {
        this.childrenToAdd.add(child);
    }

    public void removeChild(RepositoryDescriptor child) {
        this.childrenToRemove.add(child);
    }

    public void setRemoveAll(boolean all) {
        this.removeAllChildren = all;
    }

    public void setFailOnExists(boolean value) {
        this.failOnExists = value;
    }

    @Override
    protected <T> IRepository<T> initializeDestination(RepositoryDescriptor toInit, IRepositoryManager<T> mgr) throws ProvisionException {
        Predicate<RepositoryDescriptor> repositoryTypeFilter;
        String defaultName;
        String repositoryType;
        URI destinationLocation = toInit.getRepoLocation();
        if (mgr instanceof IArtifactRepositoryManager) {
            repositoryType = "org.eclipse.equinox.p2.artifact.repository.compositeRepository";
            defaultName = Messages.CompositeRepository_default_artifactRepo_name;
            repositoryTypeFilter = RepositoryDescriptor::isArtifact;
        } else if (mgr instanceof IMetadataRepositoryManager) {
            repositoryType = "org.eclipse.equinox.p2.metadata.repository.compositeRepository";
            defaultName = Messages.CompositeRepository_default_metadataRepo_name;
            repositoryTypeFilter = RepositoryDescriptor::isMetadata;
        } else {
            throw new AssertionError((Object)("Unsupported repository type: " + String.valueOf(mgr.getClass())));
        }
        mgr.removeRepository(destinationLocation);
        try {
            IRepository repository = mgr.loadRepository(destinationLocation, null);
            this.validRepositoryLocation(repository);
            if (!this.initDestinationRepository(repository, toInit)) {
                throw new ProvisionException(Status.info((String)NLS.bind((String)Messages.CompositeRepository_composite_repository_exists, (Object)destinationLocation)));
            }
            return repository;
        }
        catch (ProvisionException e) {
            if (e.getStatus().getCode() != 1000) {
                if (e.getCause() instanceof MalformedURLException) {
                    throw new ProvisionException(NLS.bind((String)Messages.exception_invalidDestination, (Object)destinationLocation), e.getCause());
                }
                throw e;
            }
            IRepository source = null;
            boolean copyChildren = false;
            try {
                if (toInit.getFormat() != null) {
                    source = mgr.loadRepository(toInit.getFormat(), null);
                } else {
                    URI sourceRepoLocation = this.sourceRepositories.stream().filter(repositoryTypeFilter).findFirst().map(RepositoryDescriptor::getRepoLocation).orElse(null);
                    if (sourceRepoLocation != null && mgr.contains(sourceRepoLocation)) {
                        source = mgr.loadRepository(sourceRepoLocation, null);
                        copyChildren = true;
                    }
                }
            }
            catch (ProvisionException sourceRepoLocation) {
                // empty catch block
            }
            try {
                String name = Optional.ofNullable(toInit.getName()).orElse(source != null ? source.getName() : defaultName);
                IRepository repo = mgr.createRepository(destinationLocation, name, repositoryType, source != null ? source.getProperties() : null);
                CompositeRepositoryApplication.initRepository(repo, toInit);
                this.setAtomicLoadingProperty(repo, toInit);
                if (copyChildren && source instanceof ICompositeRepository) {
                    ICompositeRepository sourceComposite = (ICompositeRepository)source;
                    if (repo instanceof ICompositeRepository) {
                        ICompositeRepository destinationComposite = (ICompositeRepository)repo;
                        List<URI> children = CompositeRepositoryApplication.getChildrenOriginalLocation(sourceComposite);
                        for (URI childURI : children) {
                            destinationComposite.addChild(childURI);
                        }
                    }
                }
                return repo;
            }
            catch (IllegalStateException e2) {
                mgr.removeRepository(destinationLocation);
                throw e2;
            }
        }
    }

    private static List<URI> getChildrenOriginalLocation(ICompositeRepository<?> composite) {
        CompositeRepositoryState state;
        if (composite instanceof CompositeArtifactRepository) {
            CompositeArtifactRepository artifactComposite = (CompositeArtifactRepository)composite;
            state = artifactComposite.toState();
        } else if (composite instanceof CompositeMetadataRepository) {
            CompositeMetadataRepository metadataComposite = (CompositeMetadataRepository)composite;
            state = metadataComposite.toState();
        } else {
            throw new IllegalArgumentException("Unsupported composite repository type: " + String.valueOf(composite));
        }
        return List.of(state.getChildren());
    }

    private void validRepositoryLocation(IRepository<?> repository) throws ProvisionException {
        if (repository instanceof ICompositeRepository) {
            if (this.failOnExists) {
                throw new ProvisionException(NLS.bind((String)Messages.CompositeRepository_composite_repository_exists, (Object)repository.getLocation()));
            }
            RepositoryHelper.validDestinationRepository(repository);
        }
    }

    private void setAtomicLoadingProperty(IRepository<?> repository, RepositoryDescriptor desc) {
        boolean atomic = true;
        if (desc.getAtomic() != null) {
            atomic = Boolean.valueOf(desc.getAtomic());
        }
        repository.setProperty("p2.atomic.composite.loading", Boolean.toString(atomic));
    }

    public void setComparator(String value) {
        this.comparatorID = value;
    }
}

