/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

public class ConcurrentNeutralValueMap<K, V> {
    private final ConcurrentHashMap<K, V> delegate = new ConcurrentHashMap();
    private final V neutralValue;
    private static final NullValue NULL = new NullValue();

    public ConcurrentNeutralValueMap(V neutralValue) {
        this.neutralValue = neutralValue;
    }

    public ConcurrentNeutralValueMap() {
        this(NULL);
    }

    private V wrapValue(V value) {
        return value == null ? this.neutralValue : value;
    }

    private V unwrapValue(V v) {
        return v == this.neutralValue ? null : (V)v;
    }

    public V get(Object key) {
        return this.unwrapValue(this.delegate.get(key));
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConcurrentNeutralValueMap)) {
            return false;
        }
        return this.delegate.equals(((ConcurrentNeutralValueMap)obj).delegate);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void put(K key, V value) {
        this.delegate.put(key, this.wrapValue(value));
    }

    public Value<V> putAndGetOld(K key, V value) {
        return new Wrapped(this.delegate.put(key, this.wrapValue(value)));
    }

    public V remove(Object key) {
        return this.unwrapValue(this.delegate.remove(key));
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public void clear() {
        this.delegate.clear();
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.delegate.forEach((k, v) -> action.accept((K)k, (V)this.unwrapValue(v)));
    }

    public void putIfAbsent(K key, V value) {
        this.delegate.putIfAbsent(key, this.wrapValue(value));
    }

    public Value<V> getValue(K key) {
        return new Wrapped(this.delegate.get(key));
    }

    private static final class NullValue {
        private NullValue() {
        }

        public String toString() {
            return "null";
        }

        public boolean equals(Object obj) {
            return obj instanceof NullValue;
        }

        public int hashCode() {
            return 0x55555555;
        }
    }

    public static interface Value<V> {
        public boolean isPresent();

        public V unwrapped();
    }

    private final class Wrapped
    implements Value<V> {
        V wrappedValue;

        private Wrapped(V wrappedValue) {
            this.wrappedValue = wrappedValue;
        }

        @Override
        public boolean isPresent() {
            return this.wrappedValue != null;
        }

        @Override
        public V unwrapped() {
            return ConcurrentNeutralValueMap.this.unwrapValue(this.wrappedValue);
        }
    }
}

