/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.ui.editors.NamedElementEditor;
import org.eclipse.rcptt.ui.editors.ecl.EclEditor;
import org.eclipse.rcptt.ui.editors.ecl.EclEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class Q7NamedElementMatchingStrategy
implements IEditorMatchingStrategy {
    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        IQ7Element inputElement = this.getElement(input);
        if (inputElement != null && editorRef.getId().startsWith("org.eclipse.rcptt.ui.editors")) {
            IQ7NamedElement model;
            IWorkbenchPart part = editorRef.getPart(false);
            if (part instanceof EclEditor ? (model = ((EclEditor)part).getModel()) != null : part instanceof NamedElementEditor && (model = ((NamedElementEditor)part).getModel()) != null) {
                return inputElement.equals(model);
            }
            try {
                IEditorInput editRefInput = editorRef.getEditorInput();
                if (editRefInput != null) {
                    IQ7Element refElement = this.getElement(editRefInput);
                    return inputElement.equals(refElement);
                }
            }
            catch (PartInitException e) {
                RcpttPlugin.log((String)e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    private IQ7Element getElement(IEditorInput input) {
        IQ7Element inputElement = null;
        if (input instanceof IFileEditorInput) {
            inputElement = RcpttCore.create((IResource)((IFileEditorInput)input).getFile());
        } else if (input instanceof EclEditorInput) {
            inputElement = ((EclEditorInput)input).getElement();
        }
        return inputElement;
    }
}

