/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTSemanticMatcher;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class RedundantFallingThroughBlockEndCleanUp
extends AbstractMultiFix
implements ICleanUpFix {
    public RedundantFallingThroughBlockEndCleanUp() {
        this(Collections.emptyMap());
    }

    public RedundantFallingThroughBlockEndCleanUp(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.redundant_falling_through_block_end");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.redundant_falling_through_block_end")) {
            return new String[]{MultiFixMessages.RedundantFallingThroughBlockEndCleanup_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        bld.append("if (0 < i) {\n");
        bld.append("  System.out.println(\"Doing something\");\n");
        if (!this.isEnabled("cleanup.redundant_falling_through_block_end")) {
            bld.append("  return i + 10;\n");
        }
        bld.append("}\n");
        bld.append("return i + 10;\n");
        if (this.isEnabled("cleanup.redundant_falling_through_block_end")) {
            bld.append("\n");
        }
        return bld.toString();
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.redundant_falling_through_block_end")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(Block node) {
                BlocksAndFollowingCodeVisitor blocksAndFollowingCodeVisitor = new BlocksAndFollowingCodeVisitor(node, rewriteOperations);
                node.accept((ASTVisitor)blocksAndFollowingCodeVisitor);
                return blocksAndFollowingCodeVisitor.result;
            }

            final class BlocksAndFollowingCodeVisitor
            extends ASTVisitor {
                private final Block startNode;
                private boolean result = true;
                private final /* synthetic */ List val$rewriteOperations;

                public BlocksAndFollowingCodeVisitor(Block startNode, List list) {
                    this.val$rewriteOperations = list;
                    this.startNode = startNode;
                }

                public boolean visit(Block node) {
                    return this.startNode == node;
                }

                public boolean visit(TryStatement node) {
                    return this.visitStatement((Statement)node);
                }

                public boolean visit(IfStatement node) {
                    return this.visitStatement((Statement)node);
                }

                private boolean visitStatement(Statement node) {
                    if (this.result) {
                        ArrayList<Statement> redundantStatements = new ArrayList<Statement>();
                        this.collectStatements(node, redundantStatements);
                        return this.maybeRemoveRedundantCode(node, redundantStatements);
                    }
                    return true;
                }

                private void collectStatements(Statement node, List<Statement> redundantStatements) {
                    if (node != null) {
                        TryStatement ts = ASTNodes.as(node, TryStatement.class);
                        IfStatement is = ASTNodes.as(node, IfStatement.class);
                        if (ts != null && ts.getFinally() == null) {
                            List catchClauses = ts.catchClauses();
                            for (CatchClause catchClause : catchClauses) {
                                this.doCollectStatements((Statement)catchClause.getBody(), redundantStatements);
                            }
                        } else if (is != null) {
                            this.doCollectStatements(is.getThenStatement(), redundantStatements);
                            this.doCollectStatements(is.getElseStatement(), redundantStatements);
                        }
                    }
                }

                private void doCollectStatements(Statement node, List<Statement> redundantStatements) {
                    if (node != null) {
                        redundantStatements.add(node);
                        List<Statement> statements = ASTNodes.asList(node);
                        if (!this.isEmpty(statements)) {
                            this.collectStatements(statements.get(statements.size() - 1), redundantStatements);
                        }
                    }
                }

                private boolean maybeRemoveRedundantCode(Statement node, List<Statement> redundantStatements) {
                    List<Statement> referenceStatements = ASTNodes.getNextSiblings(node);
                    if (redundantStatements.isEmpty() || this.isEmpty(referenceStatements)) {
                        return true;
                    }
                    for (Statement redundantStatement : redundantStatements) {
                        List<Statement> statements = ASTNodes.asList(redundantStatement);
                        if (this.isEmpty(statements) || !ASTNodes.fallsThrough(statements.get(statements.size() - 1))) continue;
                        Statement lastStatement = null;
                        ASTSemanticMatcher matcher = new ASTSemanticMatcher(){

                            public boolean match(SimpleName simpleName, Object other) {
                                return other instanceof SimpleName && simpleName.resolveBinding() != null && ((SimpleName)other).resolveBinding() != null && (simpleName.resolveBinding().getKind() != 3 && ((SimpleName)other).resolveBinding().getKind() != 3 || ASTNodes.isSameVariable((ASTNode)simpleName, (ASTNode)((SimpleName)other))) && super.match(simpleName, other);
                            }
                        };
                        List<Statement> stmtsToCompare = statements.size() > referenceStatements.size() ? statements.subList(statements.size() - referenceStatements.size(), statements.size()) : new ArrayList<Statement>(statements);
                        boolean match = ASTNodes.match(matcher, referenceStatements, stmtsToCompare);
                        if (!match) {
                            lastStatement = statements.get(statements.size() - 1);
                            ReturnStatement returnStatement = ASTNodes.as(lastStatement, ReturnStatement.class);
                            ContinueStatement continueStatement = ASTNodes.as(lastStatement, ContinueStatement.class);
                            if (this.isIn(node, MethodDeclaration.class) && returnStatement != null && returnStatement.getExpression() == null || this.isIn(node, EnhancedForStatement.class, ForStatement.class, WhileStatement.class, DoStatement.class) && continueStatement != null && continueStatement.getLabel() == null) {
                                stmtsToCompare = statements.size() > referenceStatements.size() + 1 ? statements.subList(statements.size() - referenceStatements.size() - 1, statements.size() - 1) : statements.subList(0, statements.size() - 1);
                                match = ASTNodes.match(matcher, referenceStatements, stmtsToCompare);
                            }
                        }
                        if (!match) continue;
                        this.val$rewriteOperations.add(new RedundantFallingThroughBlockEndOperation(redundantStatement, stmtsToCompare, lastStatement));
                        this.result = false;
                    }
                    return this.result;
                }

                private boolean isEmpty(Collection<?> collection) {
                    return collection == null || collection.isEmpty();
                }

                private boolean isIn(Statement node, Class<?> ... domClasses) {
                    Class<?>[] classArray = domClasses;
                    int n = domClasses.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<?> domClass = classArray[n2];
                        if (node.getParent().getClass().isAssignableFrom(domClass) || node.getParent() instanceof Block && node.getParent().getParent().getClass().isAssignableFrom(domClass)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.RedundantFallingThroughBlockEndCleanup_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[0]));
    }

    @Override
    public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
        return null;
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class RedundantFallingThroughBlockEndOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final Statement redundantStatement;
        private final List<Statement> stmtsToCompare;
        private final Statement lastStatement;

        public RedundantFallingThroughBlockEndOperation(Statement redundantStatement, List<Statement> stmtsToCompare, Statement lastStatement) {
            this.redundantStatement = redundantStatement;
            this.stmtsToCompare = stmtsToCompare;
            this.lastStatement = lastStatement;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.RedundantFallingThroughBlockEndCleanup_description, cuRewrite);
            if (this.redundantStatement instanceof Block) {
                for (Statement stmtToCompare : this.stmtsToCompare) {
                    rewrite.remove((ASTNode)stmtToCompare, group);
                }
                if (this.lastStatement != null) {
                    rewrite.remove((ASTNode)this.lastStatement, group);
                }
            } else if (this.redundantStatement.getLocationInParent() == IfStatement.ELSE_STATEMENT_PROPERTY) {
                rewrite.remove((ASTNode)this.redundantStatement, group);
            } else {
                rewrite.replace((ASTNode)this.redundantStatement, (ASTNode)ast.newBlock(), group);
            }
        }
    }
}

