/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;

public class FileUtil {
    static final boolean MACOSX = Platform.OS.isMac();

    public static IFileInfo attributesToFileInfo(ResourceAttributes attributes) {
        IFileInfo fileInfo = EFS.createFileInfo();
        fileInfo.setAttribute(2, attributes.isReadOnly());
        fileInfo.setAttribute(4, attributes.isExecutable());
        fileInfo.setAttribute(8, attributes.isArchive());
        fileInfo.setAttribute(16, attributes.isHidden());
        fileInfo.setAttribute(32, attributes.isSymbolicLink());
        fileInfo.setAttribute(0x2000000, attributes.isSet(0x2000000));
        fileInfo.setAttribute(0x4000000, attributes.isSet(0x4000000));
        fileInfo.setAttribute(0x8000000, attributes.isSet(0x8000000));
        fileInfo.setAttribute(0x10000000, attributes.isSet(0x10000000));
        fileInfo.setAttribute(0x20000000, attributes.isSet(0x20000000));
        fileInfo.setAttribute(0x40000000, attributes.isSet(0x40000000));
        return fileInfo;
    }

    public static IPath canonicalPath(IPath path) {
        if (path == null) {
            return null;
        }
        try {
            String pathString = path.toOSString();
            String canonicalPath = new File(pathString).getCanonicalPath();
            if (canonicalPath.equals(pathString)) {
                return path;
            }
            return IPath.fromOSString((String)canonicalPath);
        }
        catch (IOException e) {
            return path;
        }
    }

    public static IPath realPath(IPath path) {
        if (path == null) {
            return null;
        }
        IFileSystem fileSystem = EFS.getLocalFileSystem();
        if (fileSystem.isCaseSensitive()) {
            return path;
        }
        IPath realPath = path.isAbsolute() ? IPath.ROOT : IPath.EMPTY;
        String device = path.getDevice();
        if (device != null) {
            realPath = realPath.setDevice(device.toUpperCase());
        }
        IFileStore fileStore = null;
        int i = 0;
        while (i < path.segmentCount()) {
            String segment = path.segment(i);
            if (i == 0 && path.isUNC()) {
                realPath = realPath.append(segment.toUpperCase());
                realPath = realPath.makeUNC(true);
            } else if (MACOSX) {
                String[] names = realPath.toFile().list((dir, n) -> n.equalsIgnoreCase(segment));
                if (names == null || names.length == 0) {
                    realPath = realPath.append(path.removeFirstSegments(realPath.segmentCount()));
                    break;
                }
                String realName = names.length == 1 ? names[0] : segment;
                realPath = realPath.append(realName);
            } else {
                IFileInfo info;
                if (fileStore == null) {
                    fileStore = fileSystem.getStore(realPath);
                }
                if (!(info = (fileStore = fileStore.getChild(segment)).fetchInfo()).exists()) {
                    realPath = realPath.append(path.removeFirstSegments(realPath.segmentCount()));
                    break;
                }
                realPath = realPath.append(info.getName());
            }
            ++i;
        }
        if (path.hasTrailingSeparator()) {
            realPath = realPath.addTrailingSeparator();
        }
        return realPath.equals((Object)path) ? path : realPath;
    }

    public static URI canonicalURI(URI uri) {
        if (uri == null) {
            return null;
        }
        if ("file".equals(uri.getScheme())) {
            IPath canonicalPath;
            IPath inputPath = URIUtil.toPath((URI)uri);
            if (inputPath == (canonicalPath = FileUtil.canonicalPath(inputPath))) {
                return uri;
            }
            return URIUtil.toURI((IPath)canonicalPath);
        }
        return uri;
    }

    public static URI realURI(URI uri) {
        if (uri == null) {
            return null;
        }
        if ("file".equals(uri.getScheme())) {
            IPath realPath;
            IPath inputPath = URIUtil.toPath((URI)uri);
            if (inputPath == (realPath = FileUtil.realPath(inputPath))) {
                return uri;
            }
            return URIUtil.toURI((IPath)realPath);
        }
        return uri;
    }

    private static boolean computeOverlap(IPath location1, IPath location2, boolean bothDirections) {
        IPath one = location1;
        IPath two = location2;
        if (!Workspace.caseSensitive) {
            one = IPath.fromOSString((String)location1.toOSString().toLowerCase());
            two = IPath.fromOSString((String)location2.toOSString().toLowerCase());
        }
        return one.isPrefixOf(two) || bothDirections && two.isPrefixOf(one);
    }

    private static boolean computeOverlap(URI location1, URI location2, boolean bothDirections) {
        IFileStore store2;
        if (location1.equals(location2)) {
            return true;
        }
        String scheme1 = location1.getScheme();
        String scheme2 = location2.getScheme();
        if (scheme1 == null ? scheme2 != null : !scheme1.equals(scheme2)) {
            return false;
        }
        if ("file".equals(scheme1) && "file".equals(scheme2)) {
            return FileUtil.computeOverlap(URIUtil.toPath((URI)location1), URIUtil.toPath((URI)location2), bothDirections);
        }
        IFileSystem system = null;
        try {
            system = EFS.getFileSystem((String)scheme1);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (system == null) {
            String string2;
            String string1 = location1.toString();
            return string1.startsWith(string2 = location2.toString()) || bothDirections && string2.startsWith(string1);
        }
        IFileStore store1 = system.getStore(location1);
        return store1.equals(store2 = system.getStore(location2)) || store1.isParentOf(store2) || bothDirections && store2.isParentOf(store1);
    }

    public static ResourceAttributes fileInfoToAttributes(IFileInfo fileInfo) {
        ResourceAttributes attributes = new ResourceAttributes();
        attributes.setReadOnly(fileInfo.getAttribute(2));
        attributes.setArchive(fileInfo.getAttribute(8));
        attributes.setExecutable(fileInfo.getAttribute(4));
        attributes.setHidden(fileInfo.getAttribute(16));
        attributes.setSymbolicLink(fileInfo.getAttribute(32));
        attributes.set(0x2000000, fileInfo.getAttribute(0x2000000));
        attributes.set(0x4000000, fileInfo.getAttribute(0x4000000));
        attributes.set(0x8000000, fileInfo.getAttribute(0x8000000));
        attributes.set(0x10000000, fileInfo.getAttribute(0x10000000));
        attributes.set(0x20000000, fileInfo.getAttribute(0x20000000));
        attributes.set(0x40000000, fileInfo.getAttribute(0x40000000));
        return attributes;
    }

    public static boolean isOverlapping(URI location1, URI location2) {
        return FileUtil.computeOverlap(location1, location2, true);
    }

    public static boolean isPrefixOf(IPath location1, IPath location2) {
        return FileUtil.computeOverlap(location1, location2, false);
    }

    public static boolean isPrefixOf(URI location1, URI location2) {
        return FileUtil.computeOverlap(location1, location2, false);
    }

    public static IPath toPath(URI uri) {
        if (uri == null) {
            return null;
        }
        String scheme = uri.getScheme();
        if (scheme == null || "file".equals(scheme)) {
            return IPath.fromOSString((String)uri.getSchemeSpecificPart());
        }
        return null;
    }

    public static char[] readAllChars(IFile file) throws CoreException {
        byte[] content = file.readAllBytes();
        Charset charset = FileUtil.getCharset(file, content);
        return FileUtil.toCharArray(content, charset);
    }

    public static String readString(IFile file) throws CoreException {
        byte[] content = file.readAllBytes();
        Charset charset = FileUtil.getCharset(file, content);
        return FileUtil.toString(content, charset);
    }

    private static Charset getCharset(IFile file, byte[] content) {
        Charset charset;
        try {
            String encoding = file.getCharset();
            charset = Charset.forName(encoding);
        }
        catch (IllegalArgumentException | CoreException ce) {
            charset = Charset.defaultCharset();
        }
        return charset;
    }

    private static String toString(byte[] content, Charset charset) {
        int start = FileUtil.getContentStart(content, charset);
        return new String(content, start, content.length - start, charset);
    }

    private static char[] toCharArray(byte[] content, Charset charset) {
        int start = FileUtil.getContentStart(content, charset);
        return FileUtil.decode(content, start, content.length - start, charset);
    }

    private static int getContentStart(byte[] content, Charset charset) {
        byte[] bom = null;
        if (StandardCharsets.UTF_8.equals(charset)) {
            bom = IContentDescription.BOM_UTF_8;
        } else if (StandardCharsets.UTF_16BE.equals(charset)) {
            bom = IContentDescription.BOM_UTF_16BE;
        } else if (StandardCharsets.UTF_16LE.equals(charset)) {
            bom = IContentDescription.BOM_UTF_16LE;
        }
        boolean startsWithBom = bom != null && bom.length <= content.length && Arrays.equals(content, 0, bom.length, bom, 0, bom.length);
        return startsWithBom ? bom.length : 0;
    }

    private static char[] decode(byte[] content, int start, int length, Charset charset) {
        ByteBuffer srcBuffer = ByteBuffer.wrap(content, start, length);
        CharBuffer destBuffer = charset.decode(srcBuffer);
        char[] dst = destBuffer.array();
        int chars = destBuffer.remaining();
        if (chars != dst.length) {
            dst = Arrays.copyOf(dst, chars);
        }
        return dst;
    }

    private FileUtil() {
    }
}

