/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.model;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jdt.junit.model.ITestCaseElement;
import org.eclipse.jdt.junit.model.ITestElement;

public class TestCaseElement
extends TestElement
implements ITestCaseElement {
    private boolean fIgnored;
    private boolean fIsDynamicTest;

    public TestCaseElement(TestSuiteElement parent, String id, String testName, String displayName, boolean isDynamicTest, String[] parameterTypes, String uniqueId) {
        super(parent, id, testName, displayName, parameterTypes, uniqueId);
        Assert.isNotNull((Object)parent);
        this.fIsDynamicTest = isDynamicTest;
    }

    @Override
    public String getTestMethodName() {
        String testName = this.getTestName();
        int index = testName.lastIndexOf(40);
        if (index > 0) {
            return testName.substring(0, index);
        }
        index = testName.indexOf(64);
        if (index > 0) {
            return testName.substring(0, index);
        }
        return testName;
    }

    @Override
    public String getTestClassName() {
        return this.getClassName();
    }

    @Override
    public ITestElement.Result getTestResult(boolean includeChildren) {
        if (this.fIgnored) {
            return ITestElement.Result.IGNORED;
        }
        return super.getTestResult(includeChildren);
    }

    public void setIgnored(boolean ignored) {
        this.fIgnored = ignored;
    }

    public boolean isIgnored() {
        return this.fIgnored;
    }

    @Override
    public String toString() {
        return "TestCase: " + this.getTestClassName() + "." + this.getTestMethodName() + " : " + super.toString();
    }

    public boolean isDynamicTest() {
        return this.fIsDynamicTest;
    }
}

