/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.internal.group;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.DefaultContextMaker;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.core.scenario.GroupContext;

public class GroupContextMaker
extends DefaultContextMaker {
    public void makeExecutable(Context context, IQ7NamedElement source) throws ModelException {
        GroupContext group = (GroupContext)context;
        GroupContext sourceGroup = (GroupContext)source.getNamedElement();
        group.getContexts().clear();
        EList references = sourceGroup.getContextReferences();
        for (String id : references) {
            Context ctx = this.getContext(source.getQ7Project(), id);
            if (ctx != null) {
                group.getContexts().add((Object)ctx);
                continue;
            }
            throw new ModelException(null, "Failed to load referenced group context with id:" + id);
        }
    }

    private Context getContext(IQ7Project project, String id) throws ModelException {
        List ctx = project.find(IContext.class, id);
        if (ctx.size() > 0) {
            IContext ctx0 = (IContext)ctx.get(0);
            Context childContext = (Context)EcoreUtil.copy((EObject)((Context)ctx0.getNamedElement()));
            ContextType type = ctx0.getType();
            if (type != null) {
                type.getMaker().makeExecutable(childContext, (IQ7NamedElement)ctx0);
            }
            return childContext;
        }
        return null;
    }
}

