/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.xpath.saxon;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.IndependentContext;
import net.sf.saxon.trans.Variable;
import org.apache.xmlbeans.impl.store.SaxonXBeansDelegate;
import org.apache.xmlbeans.impl.xpath.saxon.XBeansIndependentContext;
import org.w3c.dom.Node;

public class XBeansXPath
implements SaxonXBeansDelegate.SelectPathInterface {
    private boolean needsDomSourceWrapping;
    private Object[] namespaceMap;
    private String _queryExpr;
    private String _contextVar;
    private String defaultNS;

    public XBeansXPath(String xpathExpr, String contextVar, Map namespaceMap, String defaultNS) {
        this._queryExpr = xpathExpr;
        this._contextVar = contextVar;
        this.defaultNS = defaultNS;
        this.namespaceMap = namespaceMap.entrySet().toArray();
        this.needsDomSourceWrapping = XBeansXPath.needsDOMSourceWrapping();
    }

    public List selectNodes(Object node) {
        try {
            DOMSource rootNode = new DOMSource((Node)node);
            XPathEvaluator xpe = new XPathEvaluator();
            Configuration c = new Configuration();
            c.setTreeModel(0);
            XBeansIndependentContext sc = new XBeansIndependentContext(c);
            if (this.defaultNS != null) {
                sc.setDefaultElementNamespace(this.defaultNS);
            }
            for (int i = 0; i < this.namespaceMap.length; ++i) {
                Map.Entry entry = (Map.Entry)this.namespaceMap[i];
                sc.declareNamespace((String)entry.getKey(), (String)entry.getValue());
            }
            xpe.setStaticContext((IndependentContext)sc);
            Variable thisVar = sc.declareVariable(this._contextVar);
            thisVar.setValue(this.needsDomSourceWrapping ? rootNode : node);
            XPathExpression exp = xpe.createExpression(this._queryExpr);
            List saxonNodes = exp.evaluate((Source)rootNode);
            ListIterator<NodeOverNodeInfo> it = saxonNodes.listIterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof NodeInfo)) continue;
                NodeOverNodeInfo n = NodeOverNodeInfo.wrap((NodeInfo)((NodeInfo)o));
                it.set(n);
            }
            return saxonNodes;
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public List selectPath(Object node) {
        return this.selectNodes(node);
    }

    private static boolean needsDOMSourceWrapping() {
        String versionString = Version.getProductVersion();
        int dot1 = versionString.indexOf(46);
        if (dot1 < 0) {
            return false;
        }
        int dot2 = versionString.indexOf(46, dot1 + 1);
        if (dot2 < 0) {
            return false;
        }
        try {
            int saxonMajorVersion = Integer.parseInt(versionString.substring(0, dot1));
            int saxonMinorVersion = Integer.parseInt(versionString.substring(dot1 + 1, dot2));
            return saxonMajorVersion == 8 && saxonMinorVersion <= 6;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

