/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IDocElement;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;

public class MemberRef
extends ASTNode
implements IDocElement {
    public static final ChildPropertyDescriptor QUALIFIER_PROPERTY = new ChildPropertyDescriptor(MemberRef.class, "qualifier", Name.class, false, false);
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(MemberRef.class, "name", SimpleName.class, true, false);
    private static final List PROPERTY_DESCRIPTORS;
    private Name optionalQualifier = null;
    private volatile SimpleName memberName;

    static {
        ArrayList propertyList = new ArrayList(3);
        MemberRef.createPropertyList(MemberRef.class, propertyList);
        MemberRef.addProperty(QUALIFIER_PROPERTY, propertyList);
        MemberRef.addProperty(NAME_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = MemberRef.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    MemberRef(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return MemberRef.propertyDescriptors(apiLevel);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == QUALIFIER_PROPERTY) {
            if (get) {
                return this.getQualifier();
            }
            this.setQualifier((Name)child);
            return null;
        }
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((SimpleName)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int getNodeType0() {
        return 67;
    }

    @Override
    ASTNode clone0(AST target) {
        MemberRef result = new MemberRef(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setQualifier((Name)ASTNode.copySubtree(target, this.getQualifier()));
        result.setName((SimpleName)ASTNode.copySubtree(target, this.getName()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getQualifier());
            this.acceptChild(visitor, this.getName());
        }
        visitor.endVisit(this);
    }

    public Name getQualifier() {
        return this.optionalQualifier;
    }

    public void setQualifier(Name name) {
        Name oldChild = this.optionalQualifier;
        this.preReplaceChild(oldChild, name, QUALIFIER_PROPERTY);
        this.optionalQualifier = name;
        this.postReplaceChild(oldChild, name, QUALIFIER_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleName getName() {
        if (this.memberName == null) {
            MemberRef memberRef = this;
            synchronized (memberRef) {
                if (this.memberName == null) {
                    this.preLazyInit();
                    this.memberName = this.postLazyInit(new SimpleName(this.ast), NAME_PROPERTY);
                }
            }
        }
        return this.memberName;
    }

    public void setName(SimpleName name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        SimpleName oldChild = this.memberName;
        this.preReplaceChild(oldChild, name, NAME_PROPERTY);
        this.memberName = name;
        this.postReplaceChild(oldChild, name, NAME_PROPERTY);
    }

    public final IBinding resolveBinding() {
        return this.ast.getBindingResolver().resolveReference(this);
    }

    @Override
    int memSize() {
        return 48;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.optionalQualifier == null ? 0 : this.getQualifier().treeSize()) + (this.memberName == null ? 0 : this.getName().treeSize());
    }
}

