/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.IOException;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lmdb.LmdbContextIdIterator;
import org.eclipse.rdf4j.sail.lmdb.ValueStore;

class LmdbContextIterator
extends LookAheadIteration<Resource> {
    private final LmdbContextIdIterator contextIdIt;
    private final ValueStore valueStore;

    public LmdbContextIterator(LmdbContextIdIterator contextIdIt, ValueStore valueStore) {
        this.contextIdIt = contextIdIt;
        this.valueStore = valueStore;
    }

    @Override
    public Resource getNextElement() throws SailException {
        try {
            long[] record;
            long contextID;
            do {
                if ((record = this.contextIdIt.next()) != null) continue;
                return null;
            } while ((contextID = record[0]) == 0L);
            Resource context = (Resource)((Object)this.valueStore.getLazyValue(contextID));
            return context;
        }
        catch (IOException e) {
            throw this.causeIOException(e);
        }
    }

    @Override
    protected void handleClose() throws SailException {
        this.contextIdIt.close();
    }

    private SailException causeIOException(IOException e) {
        return new SailException(e);
    }
}

