/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractSimpleConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LiteralComparatorFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;

public class MaxInclusiveConstraintComponent
extends AbstractSimpleConstraintComponent {
    Literal maxInclusive;

    public MaxInclusiveConstraintComponent(Literal maxInclusive) {
        this.maxInclusive = maxInclusive;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.MAX_INCLUSIVE, (Value)this.maxInclusive, new Resource[0]);
    }

    @Override
    String getSparqlFilterExpression(StatementMatcher.Variable<Value> variable, boolean negated) {
        if (negated) {
            return this.literalToString(this.maxInclusive) + " >= " + variable.asSparqlVariable();
        }
        return this.literalToString(this.maxInclusive) + " < " + variable.asSparqlVariable();
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.MaxInclusiveConstraintComponent;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new MaxInclusiveConstraintComponent(this.maxInclusive);
    }

    @Override
    Function<PlanNode, FilterPlanNode> getFilterAttacher(ConnectionsGroup connectionsGroup) {
        return parent -> new LiteralComparatorFilter((PlanNode)parent, this.maxInclusive, Compare.CompareOp.GE, connectionsGroup);
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return List.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaxInclusiveConstraintComponent that = (MaxInclusiveConstraintComponent)o;
        return this.maxInclusive.equals((Object)that.maxInclusive);
    }

    public int hashCode() {
        return this.maxInclusive.hashCode() + "MaxInclusiveConstraintComponent".hashCode();
    }
}

