/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.TransferStatement;

class ConnectionHelper {
    ConnectionHelper() {
    }

    static CloseableIteration<Statement> getCloseableIteration(final RepositoryResult<Statement> repositoryResults) {
        return new CloseableIteration<Statement>(){

            public boolean hasNext() throws SailException {
                return repositoryResults.hasNext();
            }

            public Statement next() throws SailException {
                return (Statement)repositoryResults.next();
            }

            public void remove() throws SailException {
                repositoryResults.remove();
            }

            public void close() throws SailException {
                repositoryResults.close();
            }
        };
    }

    static void transferStatements(SailConnection from, TransferStatement transfer) {
        try (CloseableIteration statements = from.getStatements(null, null, null, false, new Resource[0]);){
            while (statements.hasNext()) {
                Statement next = (Statement)statements.next();
                transfer.transfer(next.getSubject(), next.getPredicate(), next.getObject(), next.getContext());
            }
        }
    }

    static boolean isEmpty(SailConnection connection) {
        return !connection.hasStatement(null, null, null, false, new Resource[0]);
    }
}

