/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.set.primitive.BooleanSet;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedBooleanProcedure;
import org.eclipse.collections.impl.set.mutable.primitive.BooleanHashSet;

public final class ImmutableBooleanSetSerializationProxy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private BooleanSet set;

    public ImmutableBooleanSetSerializationProxy() {
    }

    public ImmutableBooleanSetSerializationProxy(BooleanSet set) {
        this.set = set;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.set.size());
        try {
            this.set.forEach((BooleanProcedure)new CheckedBooleanProcedure(){

                @Override
                public void safeValue(boolean item) throws Exception {
                    out.writeBoolean(item);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        BooleanHashSet deserializedSet = new BooleanHashSet();
        for (int i = 0; i < size; ++i) {
            deserializedSet.add(in.readBoolean());
        }
        this.set = deserializedSet;
    }

    private Object readResolve() {
        return this.set.toImmutable();
    }
}

