/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.AbstractQueryResultParser;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultParser;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;

public class BooleanTextParser
extends AbstractQueryResultParser
implements BooleanQueryResultParser {
    public final BooleanQueryResultFormat getBooleanQueryResultFormat() {
        return BooleanQueryResultFormat.TEXT;
    }

    public synchronized boolean parse(InputStream in) throws IOException, QueryResultParseException {
        boolean result;
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.US_ASCII);
        String value = IOUtil.readString((Reader)reader, (int)16);
        if ((value = value.trim()).equalsIgnoreCase("true")) {
            result = true;
        } else if (value.equalsIgnoreCase("false")) {
            result = false;
        } else {
            throw new QueryResultParseException("Invalid value: " + value);
        }
        if (this.handler != null) {
            try {
                this.handler.handleBoolean(result);
            }
            catch (QueryResultHandlerException e) {
                if (e.getCause() != null && e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new QueryResultParseException("Found an issue with the query result handler", (Throwable)e);
            }
        }
        return result;
    }

    public final QueryResultFormat getQueryResultFormat() {
        return this.getBooleanQueryResultFormat();
    }

    public void parseQueryResult(InputStream in) throws IOException, QueryResultParseException, QueryResultHandlerException {
        this.parse(in);
    }
}

