/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToShortFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction0;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToShortFunction;
import org.eclipse.collections.api.block.predicate.primitive.ObjectShortPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectShortProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.MutableShortIterator;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectShortMap;
import org.eclipse.collections.api.map.primitive.MutableObjectShortMap;
import org.eclipse.collections.api.map.primitive.MutableShortObjectMap;
import org.eclipse.collections.api.map.primitive.ObjectShortMap;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.ObjectShortPair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import org.eclipse.collections.impl.factory.primitive.ObjectShortMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableShortIterator;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedObjectShortMap;

public class UnmodifiableObjectShortMap<K>
implements MutableObjectShortMap<K>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableObjectShortMap<K> map;

    public UnmodifiableObjectShortMap(MutableObjectShortMap<K> map) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot create a UnmodifiableObjectShortMap on a null map");
        }
        this.map = map;
    }

    private boolean isAbsent(short result, K key) {
        return result == 0 && !this.containsKey(key);
    }

    private short getIfAbsentThrow(K key) {
        short result = this.map.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot add to an " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(K key, short value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putPair(ObjectShortPair<K> keyValuePair) {
        throw new UnsupportedOperationException("Cannot call putPair() on " + this.getClass().getSimpleName());
    }

    public void putAll(ObjectShortMap<? extends K> map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void updateValues(ObjectShortToShortFunction<? super K> function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public void removeKey(K key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(Object key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public short removeKeyIfAbsent(K key, short value) {
        throw new UnsupportedOperationException("Cannot call removeKeyIfAbsent() on " + this.getClass().getSimpleName());
    }

    public short getIfAbsentPut(K key, short value) {
        return this.getIfAbsentThrow(key);
    }

    public short getIfAbsentPut(K key, ShortFunction0 function) {
        return this.getIfAbsentThrow(key);
    }

    public short getIfAbsentPutWithKey(K key, ShortFunction<? super K> function) {
        return this.getIfAbsentThrow(key);
    }

    public <P> short getIfAbsentPutWith(K key, ShortFunction<? super P> function, P parameter) {
        return this.getIfAbsentThrow(key);
    }

    public short updateValue(K key, short initialValueIfAbsent, ShortToShortFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public short addToValue(K key, short toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public short get(Object key) {
        return this.map.get(key);
    }

    public short getOrThrow(Object key) {
        return this.map.getOrThrow(key);
    }

    public short getIfAbsent(Object key, short ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(short value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(ShortProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectShortProcedure<? super K> procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public MutableObjectShortMap<K> select(ObjectShortPredicate<? super K> predicate) {
        return this.map.select(predicate);
    }

    public MutableObjectShortMap<K> reject(ObjectShortPredicate<? super K> predicate) {
        return this.map.reject(predicate);
    }

    public MutableShortIterator shortIterator() {
        return new UnmodifiableShortIterator((ShortIterator)this.map.shortIterator());
    }

    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    public void each(ShortProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(ShortPredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableShortCollection select(ShortPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableShortCollection reject(ShortPredicate predicate) {
        return this.map.reject(predicate);
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V1> MutableCollection<V1> collect(ShortToObjectFunction<? extends V1> function) {
        return this.map.collect(function);
    }

    public long sum() {
        return this.map.sum();
    }

    public short max() {
        return this.map.max();
    }

    public short maxIfEmpty(short defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public short min() {
        return this.map.min();
    }

    public short minIfEmpty(short defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public short[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableShortList toSortedList() {
        return this.map.toSortedList();
    }

    public short[] toArray() {
        return this.map.toArray();
    }

    public short[] toArray(short[] target) {
        return this.map.toArray(target);
    }

    public boolean contains(short value) {
        return this.map.contains(value);
    }

    public boolean containsAll(short ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(ShortIterable source) {
        return this.map.containsAll(source);
    }

    public MutableShortList toList() {
        return this.map.toList();
    }

    public MutableShortSet toSet() {
        return this.map.toSet();
    }

    public MutableShortBag toBag() {
        return this.map.toBag();
    }

    public LazyShortIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableObjectShortMap<K> withKeyValue(K key, short value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableObjectShortMap<K> withoutKey(K key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableObjectShortMap<K> withoutAllKeys(Iterable<? extends K> keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableObjectShortMap<K> asUnmodifiable() {
        return this;
    }

    public MutableObjectShortMap<K> asSynchronized() {
        return new SynchronizedObjectShortMap(this);
    }

    public ImmutableObjectShortMap<K> toImmutable() {
        return ObjectShortMaps.immutable.withAll((ObjectShortMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public MutableShortCollection values() {
        return UnmodifiableShortCollection.of(this.map.values());
    }

    public LazyIterable<K> keysView() {
        return this.map.keysView();
    }

    public RichIterable<ObjectShortPair<K>> keyValuesView() {
        return this.map.keyValuesView();
    }

    public MutableShortObjectMap<K> flipUniqueValues() {
        return this.map.flipUniqueValues().asUnmodifiable();
    }

    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return (T)this.map.injectInto(injectedValue, function);
    }

    public RichIterable<ShortIterable> chunk(int size) {
        return this.map.chunk(size);
    }
}

