/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.iterator;

import java.util.LinkedList;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public class PrintingIteration
extends AbstractCloseableIteration<BindingSet> {
    protected final CloseableIteration<BindingSet> inner;
    protected LinkedList<BindingSet> copyQueue = new LinkedList();
    protected boolean done = false;

    public PrintingIteration(CloseableIteration<BindingSet> inner) {
        this.inner = inner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() throws QueryEvaluationException {
        int count = 0;
        while (this.inner.hasNext()) {
            BindingSet item = (BindingSet)this.inner.next();
            System.out.println(item);
            ++count;
            LinkedList<BindingSet> linkedList = this.copyQueue;
            synchronized (linkedList) {
                this.copyQueue.addLast(item);
            }
        }
        this.done = true;
        System.out.println("Done with inner queue. Processed " + count + " items.");
    }

    @Override
    public boolean hasNext() throws QueryEvaluationException {
        return !this.done || !this.copyQueue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BindingSet next() throws QueryEvaluationException {
        LinkedList<BindingSet> linkedList = this.copyQueue;
        synchronized (linkedList) {
            return this.copyQueue.removeFirst();
        }
    }

    @Override
    public void remove() throws QueryEvaluationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClose() throws QueryEvaluationException {
        this.inner.close();
        this.done = true;
        LinkedList<BindingSet> linkedList = this.copyQueue;
        synchronized (linkedList) {
            this.copyQueue.clear();
        }
    }
}

