/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.concurrent.locks;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.Properties;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.LockCleaner;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.LockMonitoring;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.LockTracking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManager {
    private static final Logger logger = LoggerFactory.getLogger(LockManager.class);
    final StampedLock lock = new StampedLock();
    private final int waitToCollect;
    LockMonitoring lockMonitoring;

    public LockManager() {
        this(false);
    }

    public LockManager(boolean trackLocks) {
        this(trackLocks, 10000);
    }

    public LockManager(boolean trackLocks, int waitToCollect) {
        this.waitToCollect = waitToCollect;
        this.lockMonitoring = trackLocks || Properties.lockTrackingEnabled() ? new LockTracking<ReadLock>(true, "LockManager", LoggerFactory.getLogger(this.getClass()), waitToCollect, Lock.ExtendedSupplier.wrap(() -> new ReadLock(this.lock), null)) : new LockCleaner<ReadLock>(false, "LockManager", LoggerFactory.getLogger(this.getClass()), Lock.ExtendedSupplier.wrap(() -> new ReadLock(this.lock), null));
    }

    public boolean isActiveLock() {
        return this.lock.isReadLocked();
    }

    public void waitForActiveLocks() throws InterruptedException {
        while (this.isActiveLock()) {
            long writeLock;
            if (this.lockMonitoring.requiresManualCleanup()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                writeLock = this.lock.tryWriteLock(this.waitToCollect, TimeUnit.MILLISECONDS);
                if (writeLock == 0L) {
                    this.lockMonitoring.runCleanup();
                    continue;
                }
                this.lock.unlockWrite(writeLock);
                return;
            }
            writeLock = this.lock.writeLockInterruptibly();
            this.lock.unlockWrite(writeLock);
        }
    }

    public Lock createLock(String alias) {
        try {
            return this.lockMonitoring.getLock(alias);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    static class ReadLock
    implements Lock {
        private final StampedLock lock;
        private long stamp;

        public ReadLock(StampedLock lock) {
            this.stamp = lock.readLock();
            this.lock = lock;
        }

        @Override
        public boolean isActive() {
            return this.stamp != 0L;
        }

        @Override
        public void release() {
            long temp = this.stamp;
            this.stamp = 0L;
            if (temp == 0L) {
                throw new IllegalMonitorStateException("Trying to release a lock that is not locked");
            }
            this.lock.unlockRead(temp);
        }
    }
}

