/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.factory.set.primitive.ImmutableCharSetFactory;
import org.eclipse.collections.api.set.primitive.ImmutableCharSet;
import org.eclipse.collections.impl.factory.primitive.CharSets;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableCharEmptySet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableCharSingletonSet;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;

public enum ImmutableCharSetFactoryImpl implements ImmutableCharSetFactory
{
    INSTANCE;


    public ImmutableCharSet empty() {
        return ImmutableCharEmptySet.INSTANCE;
    }

    public ImmutableCharSet of() {
        return this.empty();
    }

    public ImmutableCharSet with() {
        return this.empty();
    }

    public ImmutableCharSet of(char one) {
        return this.with(one);
    }

    public ImmutableCharSet with(char one) {
        return new ImmutableCharSingletonSet(one);
    }

    public ImmutableCharSet of(char ... items) {
        return this.with(items);
    }

    public ImmutableCharSet with(char ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return CharHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableCharSet ofAll(CharIterable items) {
        return this.withAll(items);
    }

    public ImmutableCharSet withAll(CharIterable items) {
        if (items instanceof ImmutableCharSet) {
            return (ImmutableCharSet)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableCharSet ofAll(Iterable<Character> iterable) {
        return this.withAll(iterable);
    }

    public ImmutableCharSet withAll(Iterable<Character> iterable) {
        return CharSets.mutable.withAll(iterable).toImmutable();
    }
}

