/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.util.Objects;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;

@Experimental
public class GenericStatement<R extends Resource, I extends IRI, V extends Value>
implements Statement {
    private static final long serialVersionUID = -4747234187477906748L;
    protected final R subject;
    protected final I predicate;
    protected final V object;
    protected final R context;

    public GenericStatement(R subject, I predicate, V object, R context) {
        this.subject = (Resource)Objects.requireNonNull(subject, "subject must not be null");
        this.predicate = (IRI)Objects.requireNonNull(predicate, "predicate must not be null");
        this.object = (Value)Objects.requireNonNull(object, "object must not be null");
        this.context = context;
    }

    public R getSubject() {
        return this.subject;
    }

    public I getPredicate() {
        return this.predicate;
    }

    public V getObject() {
        return this.object;
    }

    public R getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Statement)) {
            return false;
        }
        Statement that = (Statement)o;
        return this.subject.equals((Object)that.getSubject()) && this.predicate.equals((Object)that.getPredicate()) && this.object.equals((Object)that.getObject()) && Objects.equals(this.context, that.getContext());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.subject.hashCode();
        result = 31 * result + this.predicate.hashCode();
        result = 31 * result + this.object.hashCode();
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        return result;
    }

    public String toString() {
        return "(" + String.valueOf(this.subject) + ", " + String.valueOf(this.predicate) + ", " + String.valueOf(this.object) + ") [" + String.valueOf(this.context) + "]";
    }
}

