/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.UnsortedMapIterable;
import org.eclipse.collections.api.map.sorted.SortedMapIterable;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.api.multimap.sortedset.MutableSortedSetMultimap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.CollectProcedure;
import org.eclipse.collections.impl.block.procedure.CollectionAddProcedure;
import org.eclipse.collections.impl.block.procedure.CountProcedure;
import org.eclipse.collections.impl.block.procedure.MapEntryToProcedure2;
import org.eclipse.collections.impl.block.procedure.MapPutProcedure;
import org.eclipse.collections.impl.block.procedure.RejectProcedure;
import org.eclipse.collections.impl.block.procedure.SelectProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectBooleanProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectByteProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectCharProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectDoubleProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectFloatProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectIntProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectLongProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectShortProcedure;
import org.eclipse.collections.impl.factory.Multimaps;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.map.mutable.MapAdapter;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.set.sorted.TreeSortedSetMultimap;
import org.eclipse.collections.impl.tuple.AbstractImmutableEntry;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.internal.IterableIterate;

public final class MapIterate {
    private MapIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean notEmpty(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    public static <K, V> V getIfAbsentPut(Map<K, V> map, K key, Function0<? extends V> instanceBlock) {
        if (map instanceof MutableMap) {
            return (V)((MutableMap)map).getIfAbsentPut(key, instanceBlock);
        }
        Object result = map.get(key);
        if (MapIterate.isAbsent(result, map, key)) {
            result = instanceBlock.value();
            map.put(key, result);
        }
        return result;
    }

    public static <K, V, P> V getIfAbsentPutWith(Map<K, V> map, K key, Function<? super P, ? extends V> function, P parameter) {
        Object result = map.get(key);
        if (MapIterate.isAbsent(result, map, key)) {
            result = function.valueOf(parameter);
            map.put(key, result);
        }
        return result;
    }

    public static <K, V> V getIfAbsent(Map<K, V> map, K key, Function0<? extends V> instanceBlock) {
        if (map instanceof UnsortedMapIterable) {
            return (V)((MapIterable)map).getIfAbsent(key, instanceBlock);
        }
        Object result = map.get(key);
        if (MapIterate.isAbsent(result, map, key)) {
            result = instanceBlock.value();
        }
        return result;
    }

    public static <K, V, P> V getIfAbsentWith(Map<K, V> map, K key, Function<? super P, ? extends V> function, P parameter) {
        if (map instanceof UnsortedMapIterable) {
            return (V)((MapIterable)map).getIfAbsentWith(key, function, parameter);
        }
        Object result = map.get(key);
        if (MapIterate.isAbsent(result, map, key)) {
            result = function.valueOf(parameter);
        }
        return result;
    }

    public static <K, V> V getIfAbsentDefault(Map<K, V> map, K key, V defaultValue) {
        V result = map.get(key);
        if (MapIterate.isAbsent(result, map, key)) {
            result = defaultValue;
        }
        return result;
    }

    private static <K, V> boolean isAbsent(V result, Map<K, V> map, K key) {
        return result == null && !map.containsKey(key);
    }

    public static <K, V, A> A ifPresentApply(Map<K, V> map, K key, Function<? super V, ? extends A> function) {
        if (map instanceof UnsortedMapIterable) {
            return (A)((MapIterable)map).ifPresentApply(key, function);
        }
        V result = map.get(key);
        return (A)(MapIterate.isAbsent(result, map, key) ? null : function.valueOf(result));
    }

    public static <K, V> MutableList<V> select(Map<K, V> map, Predicate<? super V> predicate) {
        return MapIterate.select(map, predicate, FastList.newList());
    }

    public static <K, V, R extends Collection<V>> R select(Map<K, V> map, Predicate<? super V> predicate, R targetCollection) {
        SelectProcedure<? super V> procedure = new SelectProcedure<V>(predicate, targetCollection);
        MapIterate.forEachValue(map, procedure);
        return targetCollection;
    }

    public static <K, V> int count(Map<K, V> map, Predicate<? super V> predicate) {
        CountProcedure<V> procedure = new CountProcedure<V>(predicate);
        MapIterate.forEachValue(map, procedure);
        return procedure.getCount();
    }

    public static <K, V> MutableMap<K, V> selectMapOnEntry(Map<K, V> map, Predicate2<? super K, ? super V> predicate) {
        return MapIterate.selectMapOnEntry(map, predicate, UnifiedMap.newMap());
    }

    public static <K, V, R extends Map<K, V>> R selectMapOnEntry(Map<K, V> map, Predicate2<? super K, ? super V> predicate, R target) {
        MapPutProcedure mapTransferProcedure = new MapPutProcedure(target);
        Procedure2 & Serializable procedure = (Procedure2 & Serializable)(key, value) -> {
            if (predicate.accept(key, value)) {
                mapTransferProcedure.value(key, value);
            }
        };
        MapIterate.forEachKeyValue(map, procedure);
        return target;
    }

    public static <K, V> MutableMap<K, V> selectMapOnKey(Map<K, V> map, Predicate<? super K> predicate) {
        UnifiedMap resultMap = UnifiedMap.newMap();
        MapPutProcedure mapTransferProcedure = new MapPutProcedure(resultMap);
        Procedure2 & Serializable procedure = (Procedure2 & Serializable)(key, value) -> {
            if (predicate.accept(key)) {
                mapTransferProcedure.value(key, value);
            }
        };
        MapIterate.forEachKeyValue(map, procedure);
        return resultMap;
    }

    public static <K, V> MutableMap<K, V> selectMapOnValue(Map<K, V> map, Predicate<? super V> predicate) {
        UnifiedMap resultMap = UnifiedMap.newMap();
        MapPutProcedure mapTransferProcedure = new MapPutProcedure(resultMap);
        Procedure2 & Serializable procedure = (Procedure2 & Serializable)(key, value) -> {
            if (predicate.accept(value)) {
                mapTransferProcedure.value(key, value);
            }
        };
        MapIterate.forEachKeyValue(map, procedure);
        return resultMap;
    }

    public static <K, V> MutableList<V> reject(Map<K, V> map, Predicate<? super V> predicate) {
        return MapIterate.reject(map, predicate, FastList.newList());
    }

    public static <K, V, R extends Collection<V>> R reject(Map<K, V> map, Predicate<? super V> predicate, R targetCollection) {
        RejectProcedure<? super V> procedure = new RejectProcedure<V>(predicate, targetCollection);
        MapIterate.forEachValue(map, procedure);
        return targetCollection;
    }

    public static <K, V> MutableMap<K, V> rejectMapOnEntry(Map<K, V> map, Predicate2<? super K, ? super V> predicate) {
        return MapIterate.rejectMapOnEntry(map, predicate, UnifiedMap.newMap());
    }

    public static <K, V, R extends Map<K, V>> R rejectMapOnEntry(Map<K, V> map, Predicate2<? super K, ? super V> predicate, R target) {
        MapIterate.forEachKeyValue(map, (Procedure2 & Serializable)(argument1, argument2) -> {
            if (!predicate.accept(argument1, argument2)) {
                target.put(argument1, argument2);
            }
        });
        return target;
    }

    public static <K, V> Collection<K> addAllKeysTo(Map<K, V> map, Collection<K> targetCollection) {
        MapIterate.forEachKey(map, CollectionAddProcedure.on(targetCollection));
        return targetCollection;
    }

    public static <K, V> Collection<V> addAllValuesTo(Map<K, V> map, Collection<V> targetCollection) {
        MapIterate.forEachValue(map, CollectionAddProcedure.on(targetCollection));
        return targetCollection;
    }

    public static <K, V, A> MutableList<A> collect(Map<K, V> map, Function<? super V, ? extends A> function) {
        return MapIterate.collect(map, function, FastList.newList(map.size()));
    }

    public static <K, V> MutableBooleanCollection collectBoolean(Map<K, V> map, BooleanFunction<? super V> booleanFunction) {
        return MapIterate.collectBoolean(map, booleanFunction, new BooleanArrayList(map.size()));
    }

    public static <K, V, R extends MutableBooleanCollection> R collectBoolean(Map<K, V> map, BooleanFunction<? super V> booleanFunction, R target) {
        MapIterate.forEachValue(map, new CollectBooleanProcedure<V>(booleanFunction, target));
        return target;
    }

    public static <K, V> MutableByteCollection collectByte(Map<K, V> map, ByteFunction<? super V> byteFunction) {
        return MapIterate.collectByte(map, byteFunction, new ByteArrayList(map.size()));
    }

    public static <K, V, R extends MutableByteCollection> R collectByte(Map<K, V> map, ByteFunction<? super V> byteFunction, R target) {
        MapIterate.forEachValue(map, new CollectByteProcedure<V>(byteFunction, target));
        return target;
    }

    public static <K, V> MutableCharCollection collectChar(Map<K, V> map, CharFunction<? super V> charFunction) {
        return MapIterate.collectChar(map, charFunction, new CharArrayList(map.size()));
    }

    public static <K, V, R extends MutableCharCollection> R collectChar(Map<K, V> map, CharFunction<? super V> charFunction, R target) {
        MapIterate.forEachValue(map, new CollectCharProcedure<V>(charFunction, target));
        return target;
    }

    public static <K, V> MutableDoubleCollection collectDouble(Map<K, V> map, DoubleFunction<? super V> doubleFunction) {
        return MapIterate.collectDouble(map, doubleFunction, new DoubleArrayList(map.size()));
    }

    public static <K, V, R extends MutableDoubleCollection> R collectDouble(Map<K, V> map, DoubleFunction<? super V> doubleFunction, R target) {
        MapIterate.forEachValue(map, new CollectDoubleProcedure<V>(doubleFunction, target));
        return target;
    }

    public static <K, V> MutableFloatCollection collectFloat(Map<K, V> map, FloatFunction<? super V> floatFunction) {
        return MapIterate.collectFloat(map, floatFunction, new FloatArrayList(map.size()));
    }

    public static <K, V, R extends MutableFloatCollection> R collectFloat(Map<K, V> map, FloatFunction<? super V> floatFunction, R target) {
        MapIterate.forEachValue(map, new CollectFloatProcedure<V>(floatFunction, target));
        return target;
    }

    public static <K, V> MutableIntCollection collectInt(Map<K, V> map, IntFunction<? super V> intFunction) {
        return MapIterate.collectInt(map, intFunction, new IntArrayList(map.size()));
    }

    public static <K, V, R extends MutableIntCollection> R collectInt(Map<K, V> map, IntFunction<? super V> intFunction, R target) {
        MapIterate.forEachValue(map, new CollectIntProcedure<V>(intFunction, target));
        return target;
    }

    public static <K, V> MutableLongCollection collectLong(Map<K, V> map, LongFunction<? super V> longFunction) {
        return MapIterate.collectLong(map, longFunction, new LongArrayList(map.size()));
    }

    public static <K, V, R extends MutableLongCollection> R collectLong(Map<K, V> map, LongFunction<? super V> longFunction, R target) {
        MapIterate.forEachValue(map, new CollectLongProcedure<V>(longFunction, target));
        return target;
    }

    public static <K, V> MutableShortCollection collectShort(Map<K, V> map, ShortFunction<? super V> shortFunction) {
        return MapIterate.collectShort(map, shortFunction, new ShortArrayList(map.size()));
    }

    public static <K, V, R extends MutableShortCollection> R collectShort(Map<K, V> map, ShortFunction<? super V> shortFunction, R target) {
        MapIterate.forEachValue(map, new CollectShortProcedure<V>(shortFunction, target));
        return target;
    }

    public static <K, V, K2, V2> MutableMap<K2, V2> collect(Map<K, V> map, Function2<? super K, ? super V, Pair<K2, V2>> function) {
        return MapIterate.collect(map, function, UnifiedMap.newMap(map.size()));
    }

    public static <K1, V1, K2, V2, R extends Map<K2, V2>> R collect(Map<K1, V1> map, Function2<? super K1, ? super V1, Pair<K2, V2>> function, R target) {
        MapIterate.forEachKeyValue(map, (Procedure2 & Serializable)(key, value) -> {
            Pair pair = (Pair)function.value(key, value);
            target.put(pair.getOne(), pair.getTwo());
        });
        return target;
    }

    public static <K, V, V2> MutableMap<K, V2> collectValues(Map<K, V> map, Function2<? super K, ? super V, ? extends V2> function) {
        return MapIterate.collectValues(map, function, UnifiedMap.newMap(map.size()));
    }

    public static <K, V, V2, R extends Map<K, V2>> R collectValues(Map<K, V> map, Function2<? super K, ? super V, ? extends V2> function, R target) {
        MapIterate.forEachKeyValue(map, (Procedure2 & Serializable)(key, value) -> target.put(key, function.value(key, value)));
        return target;
    }

    public static <K1, V1, K2, V2> MutableMap<K2, V2> collectIf(Map<K1, V1> map, Function2<? super K1, ? super V1, Pair<K2, V2>> function, Predicate2<? super K1, ? super V1> predicate) {
        return MapIterate.collectIf(map, function, predicate, UnifiedMap.newMap());
    }

    public static <K1, V1, K2, V2> MutableMap<K2, V2> collectIf(Map<K1, V1> map, Function2<? super K1, ? super V1, Pair<K2, V2>> function, Predicate2<? super K1, ? super V1> predicate, Map<K2, V2> target) {
        MutableMap result = MapAdapter.adapt(target);
        MapIterate.forEachKeyValue(map, (Procedure2 & Serializable)(key, value) -> {
            if (predicate.accept(key, value)) {
                Pair pair = (Pair)function.value(key, value);
                result.put(pair.getOne(), pair.getTwo());
            }
        });
        return result;
    }

    public static <K1, V1, K2, V2> MutableMap<K2, V2> collect(Map<K1, V1> map, Function<? super K1, ? extends K2> keyFunction, Function<? super V1, ? extends V2> valueFunction) {
        return MapIterate.collect(map, keyFunction, valueFunction, UnifiedMap.newMap());
    }

    public static <K1, V1, K2, V2> MutableMap<K2, V2> collect(Map<K1, V1> map, Function<? super K1, ? extends K2> keyFunction, Function<? super V1, ? extends V2> valueFunction, Map<K2, V2> target) {
        return MapIterate.collect(map, (Function2 & Serializable)(key, value) -> Tuples.pair(keyFunction.valueOf(key), valueFunction.valueOf(value)), MapAdapter.adapt(target));
    }

    public static <K, V, A, R extends Collection<A>> R collect(Map<K, V> map, Function<? super V, ? extends A> function, R targetCollection) {
        CollectProcedure<? super V, ? extends A> procedure = new CollectProcedure<V, A>(function, targetCollection);
        MapIterate.forEachValue(map, procedure);
        return targetCollection;
    }

    public static <K, V> void forEachValue(Map<K, V> map, Procedure<? super V> procedure) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot perform a forEachValue on null");
        }
        if (MapIterate.notEmpty(map)) {
            if (map instanceof UnsortedMapIterable) {
                ((MapIterable)map).forEachValue(procedure);
            } else {
                IterableIterate.forEach(map.values(), procedure);
            }
        }
    }

    public static <K, V> void forEachKey(Map<K, V> map, Procedure<? super K> procedure) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot perform a forEachKey on null");
        }
        if (MapIterate.notEmpty(map)) {
            if (map instanceof UnsortedMapIterable) {
                ((MapIterable)map).forEachKey(procedure);
            } else {
                IterableIterate.forEach(map.keySet(), procedure);
            }
        }
    }

    public static <K, V> void forEachKeyValue(Map<K, V> map, Procedure2<? super K, ? super V> procedure) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot perform a forEachKeyValue on null");
        }
        if (MapIterate.notEmpty(map)) {
            if (map instanceof UnsortedMapIterable) {
                ((MapIterable)map).forEachKeyValue(procedure);
            } else {
                IterableIterate.forEach(map.entrySet(), new MapEntryToProcedure2<K, V>(procedure));
            }
        }
    }

    public static <K, V> MutableMap<V, K> flipUniqueValues(MapIterable<K, V> mapIterable) {
        UnifiedMap result = UnifiedMap.newMap();
        mapIterable.forEachKeyValue((Procedure2 & Serializable)(key, value) -> {
            Object oldKey = result.put(value, key);
            if (oldKey != null) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + oldKey + " and key: " + key);
            }
        });
        return result;
    }

    public static <K, V> Pair<K, V> detect(Map<K, V> map, Predicate2<? super K, ? super V> predicate) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot perform a detect on null");
        }
        if (map instanceof ImmutableMap || map instanceof MutableMap) {
            Object entries = map instanceof ImmutableMap ? ((ImmutableMap)map).keyValuesView() : LazyIterate.adapt(map.entrySet()).collect(AbstractImmutableEntry.getPairFunction());
            return (Pair)entries.detect((Predicate & Serializable)each -> predicate.accept(each.getOne(), each.getTwo()));
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!predicate.accept(entry.getKey(), entry.getValue())) continue;
            return Tuples.pairFrom(entry);
        }
        return null;
    }

    public static <K, V> V detect(Map<K, V> map, Predicate<? super V> predicate) {
        return IterableIterate.detect(map.values(), predicate);
    }

    public static <K, V> Optional<Pair<K, V>> detectOptional(Map<K, V> map, Predicate2<? super K, ? super V> predicate) {
        return Optional.ofNullable(MapIterate.detect(map, predicate));
    }

    public static <K, V> Optional<V> detectOptional(Map<K, V> map, Predicate<? super V> predicate) {
        return IterableIterate.detectOptional(map.values(), predicate);
    }

    public static <K, V> V detectIfNone(Map<K, V> map, Predicate<? super V> predicate, V ifNone) {
        return Iterate.detectIfNone(map.values(), predicate, ifNone);
    }

    public static <K, V, IV> IV injectInto(IV injectValue, Map<K, V> map, Function2<? super IV, ? super V, ? extends IV> function) {
        return Iterate.injectInto(injectValue, map.values(), function);
    }

    public static <IV, K, V> IV injectIntoIf(IV initialValue, Map<K, V> map, Predicate<? super V> predicate, Function2<? super IV, ? super V, ? extends IV> function) {
        Function2 & Serializable ifFunction = (Function2 & Serializable)(accumulator, item) -> {
            if (predicate.accept(item)) {
                return function.value(accumulator, item);
            }
            return accumulator;
        };
        return Iterate.injectInto(initialValue, map.values(), ifFunction);
    }

    public static <K, V> boolean anySatisfy(Map<K, V> map, Predicate<? super V> predicate) {
        return IterableIterate.anySatisfy(map.values(), predicate);
    }

    public static <K, V> boolean allSatisfy(Map<K, V> map, Predicate<? super V> predicate) {
        return IterableIterate.allSatisfy(map.values(), predicate);
    }

    public static <K, V> boolean noneSatisfy(Map<K, V> map, Predicate<? super V> predicate) {
        return IterableIterate.noneSatisfy(map.values(), predicate);
    }

    public static <K, V> MutableList<Pair<K, V>> toListOfPairs(Map<K, V> map) {
        FastList pairs = FastList.newList(map.size());
        MapIterate.forEachKeyValue(map, (Procedure2 & Serializable)(key, value) -> pairs.add(Tuples.pair(key, value)));
        return pairs;
    }

    public static <K, V> MutableList<V> toSortedList(Map<K, V> map, Comparator<? super V> comparator) {
        return Iterate.toSortedList(map.values(), comparator);
    }

    public static <K, V> MutableMap<V, K> reverseMapping(Map<K, V> map) {
        UnifiedMap reverseMap = UnifiedMap.newMap(map.size());
        MapIterate.forEachKeyValue(map, (Procedure2 & Serializable)(sourceKey, sourceValue) -> reverseMap.put(sourceValue, sourceKey));
        return reverseMap;
    }

    public static <K, V> int occurrencesOf(Map<K, V> map, V object) {
        return Iterate.count(map.values(), Predicates.equal(object));
    }

    public static <K, V, A> int occurrencesOfAttribute(Map<K, V> map, Function<? super V, ? extends A> function, A object) {
        return Iterate.count(map.values(), Predicates.attributeEqual(function, object));
    }

    public static <K, V> MutableSetMultimap<V, K> flip(MapIterable<K, V> iMap) {
        MutableSetMultimap result = Multimaps.mutable.set.with();
        iMap.forEachKeyValue((Procedure2 & Serializable)(key, val) -> result.put(val, key));
        return result;
    }

    public static <K, V> MutableSortedSetMultimap<V, K> flip(SortedMapIterable<K, V> iMap) {
        TreeSortedSetMultimap result = new TreeSortedSetMultimap(iMap.comparator());
        iMap.forEachKeyValue((Procedure2 & Serializable)(key, val) -> result.put(val, key));
        return result;
    }
}

