/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.repository;

import java.util.Collection;
import org.eclipse.rdf4j.federated.repository.FedXRepositoryConfig;
import org.eclipse.rdf4j.federated.util.Vocabulary;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;

public class FedXRepositoryConfigBuilder {
    private final Model members = new TreeModel();

    public static FedXRepositoryConfigBuilder create() {
        return new FedXRepositoryConfigBuilder();
    }

    private FedXRepositoryConfigBuilder() {
    }

    public FedXRepositoryConfigBuilder withResolvableEndpoint(String memberId) {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        this.members.add((Resource)vf.createIRI("http://rdf4j.org/config/federation#", memberId), Vocabulary.FEDX.STORE, (Value)vf.createLiteral("ResolvableRepository"), new Resource[0]);
        this.members.add((Resource)vf.createIRI("http://rdf4j.org/config/federation#", memberId), Vocabulary.FEDX.REPOSITORY_NAME, (Value)vf.createLiteral(memberId), new Resource[0]);
        return this;
    }

    public FedXRepositoryConfigBuilder withResolvableEndpoint(Collection<String> memberIds) {
        memberIds.stream().forEach(memberId -> this.withResolvableEndpoint((String)memberId));
        return this;
    }

    public FedXRepositoryConfigBuilder withMembers(Collection<Statement> members) {
        this.members.addAll(members);
        return this;
    }

    public FedXRepositoryConfig build() {
        FedXRepositoryConfig config = new FedXRepositoryConfig();
        config.setMembers(this.members);
        return config;
    }

    public RepositoryConfig build(String repositoryId, String repositoryTitle) {
        return new RepositoryConfig(repositoryId, repositoryTitle, (RepositoryImplConfig)this.build());
    }
}

