/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.targets;

import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.Targetable;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;

public class TargetChain {
    private final ArrayDeque<Targetable> chain = new ArrayDeque();
    private boolean optimizable = true;

    public TargetChain() {
    }

    public TargetChain(TargetChain targetChain) {
        this.optimizable = targetChain.optimizable;
    }

    public TargetChain add(Targetable o) {
        TargetChain targetChain = new TargetChain(this);
        targetChain.chain.addAll(this.chain);
        targetChain.chain.addLast(o);
        return targetChain;
    }

    public TargetChain setOptimizable(boolean optimizable) {
        TargetChain targetChain = new TargetChain(this);
        targetChain.chain.addAll(this.chain);
        if (targetChain.optimizable) {
            targetChain.optimizable = optimizable;
        }
        return targetChain;
    }

    public boolean isOptimizable() {
        return this.optimizable;
    }

    public Optional<Path> getPath() {
        Targetable last = this.chain.getLast();
        if (last instanceof Path) {
            return Optional.of((Path)last);
        }
        return Optional.empty();
    }

    public EffectiveTarget getEffectiveTarget(ConstraintComponent.Scope scope, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        ArrayDeque<Targetable> newChain = new ArrayDeque<Targetable>(this.chain);
        Targetable targetable = null;
        if (scope == ConstraintComponent.Scope.propertyShape) {
            targetable = newChain.removeLast();
        }
        return new EffectiveTarget(newChain, targetable, rdfsSubClassOfReasoner, stableRandomVariableProvider);
    }

    public Set<Namespace> getNamespaces() {
        return this.chain.stream().flatMap(targetable -> targetable.getNamespaces().stream()).collect(Collectors.toSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetChain that = (TargetChain)o;
        if (this.chain.size() != that.chain.size()) {
            return false;
        }
        for (Targetable targetable : this.chain) {
            if (that.chain.contains(targetable)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        for (Targetable targetable : this.chain) {
            hashCode += targetable.hashCode();
        }
        return hashCode;
    }
}

