/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.vocabulary.FOAF;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.TupleExprIRRenderer;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrStatementPattern;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSubSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class FusePrePathThenUnionAlternationTransform
extends BaseTransform {
    private FusePrePathThenUnionAlternationTransform() {
    }

    public static IrBGP apply(IrBGP bgp, TupleExprIRRenderer r) {
        if (bgp == null) {
            return null;
        }
        List<IrNode> in = bgp.getLines();
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        for (int i = 0; i < in.size(); ++i) {
            IrNode n = in.get(i);
            if ((n = n.transformChildren(child -> {
                if (child instanceof IrBGP) {
                    return FusePrePathThenUnionAlternationTransform.apply((IrBGP)child, r);
                }
                return child;
            })) instanceof IrPathTriple && i + 1 < in.size() && in.get(i + 1) instanceof IrUnion) {
                IrPathTriple pre = (IrPathTriple)n;
                Var mid = pre.getObject();
                if (!FusePrePathThenUnionAlternationTransform.isAnonPathVar(mid)) {
                    out.add(n);
                    continue;
                }
                IrUnion u = (IrUnion)in.get(i + 1);
                if (u.isNewScope() && !FusePrePathThenUnionAlternationTransform.unionBranchesAllHaveAnonPathBridge(u) || u.getBranches().size() != 2) {
                    out.add(n);
                    continue;
                }
                Tail t0 = FusePrePathThenUnionAlternationTransform.parseTail(u.getBranches().get(0), mid, r);
                Tail t1 = FusePrePathThenUnionAlternationTransform.parseTail(u.getBranches().get(1), mid, r);
                if (t0 != null && t1 != null && FusePrePathThenUnionAlternationTransform.sameVar(t0.end, t1.end)) {
                    IrStatementPattern tail;
                    String alt = t0.path.equals(t1.path) ? t0.path : "(" + t0.path + "|" + t1.path + ")";
                    String preTxt = FusePrePathThenUnionAlternationTransform.normalizePrePrefix(pre.getPathText());
                    String fused = preTxt + "/" + alt;
                    Var endVar = t0.end;
                    if (i + 2 < in.size() && in.get(i + 2) instanceof IrStatementPattern && (tail = (IrStatementPattern)in.get(i + 2)).getPredicate() != null && tail.getPredicate().hasValue() && FOAF.NAME.equals(tail.getPredicate().getValue()) && FusePrePathThenUnionAlternationTransform.sameVar(endVar, tail.getSubject())) {
                        fused = fused + "/" + r.convertIRIToString(FOAF.NAME);
                        endVar = tail.getObject();
                        out.add(new IrPathTriple(pre.getSubject(), fused, endVar, false, pre.getPathVars()));
                        i += 2;
                        continue;
                    }
                    out.add(new IrPathTriple(pre.getSubject(), fused, endVar, false, pre.getPathVars()));
                    ++i;
                    continue;
                }
            }
            if (n instanceof IrSubSelect) {
                out.add(n);
                continue;
            }
            IrNode rec = BaseTransform.rewriteContainers(n, child -> FusePrePathThenUnionAlternationTransform.apply(child, r));
            out.add(rec);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    private static Tail parseTail(IrBGP b, Var mid, TupleExprIRRenderer r) {
        if (b == null) {
            return null;
        }
        if (b.getLines().size() == 1) {
            IrStatementPattern sp;
            IrNode only = b.getLines().get(0);
            if (only instanceof IrPathTriple) {
                IrPathTriple pt = (IrPathTriple)only;
                if (FusePrePathThenUnionAlternationTransform.sameVar(mid, pt.getSubject())) {
                    return new Tail(pt.getObject(), pt.getPathText());
                }
                if (FusePrePathThenUnionAlternationTransform.sameVar(mid, pt.getObject())) {
                    return new Tail(pt.getSubject(), "^(" + pt.getPathText() + ")");
                }
            } else if (only instanceof IrStatementPattern && FusePrePathThenUnionAlternationTransform.isConstantIriPredicate(sp = (IrStatementPattern)only)) {
                String step = FusePrePathThenUnionAlternationTransform.iri(sp.getPredicate(), r);
                if (FusePrePathThenUnionAlternationTransform.sameVar(mid, sp.getSubject())) {
                    return new Tail(sp.getObject(), step);
                }
                if (FusePrePathThenUnionAlternationTransform.sameVar(mid, sp.getObject())) {
                    return new Tail(sp.getSubject(), "^" + step);
                }
            }
        }
        if (b.getLines().size() == 2 && b.getLines().get(0) instanceof IrStatementPattern && b.getLines().get(1) instanceof IrStatementPattern) {
            Object step1;
            IrStatementPattern a = (IrStatementPattern)b.getLines().get(0);
            IrStatementPattern c = (IrStatementPattern)b.getLines().get(1);
            if (a.getPredicate() == null || !a.getPredicate().hasValue() || !(a.getPredicate().getValue() instanceof IRI)) {
                return null;
            }
            if (c.getPredicate() == null || !c.getPredicate().hasValue() || !(c.getPredicate().getValue() instanceof IRI)) {
                return null;
            }
            if (FusePrePathThenUnionAlternationTransform.sameVar(mid, a.getSubject()) && FusePrePathThenUnionAlternationTransform.sameVar(a.getObject(), c.getSubject())) {
                step1 = FusePrePathThenUnionAlternationTransform.iri(a.getPredicate(), r);
                String step2 = FusePrePathThenUnionAlternationTransform.iri(c.getPredicate(), r);
                return new Tail(c.getObject(), (String)step1 + "/" + step2);
            }
            if (FusePrePathThenUnionAlternationTransform.sameVar(mid, a.getObject()) && FusePrePathThenUnionAlternationTransform.sameVar(a.getSubject(), c.getObject())) {
                step1 = "^" + FusePrePathThenUnionAlternationTransform.iri(a.getPredicate(), r);
                String step2 = "^" + FusePrePathThenUnionAlternationTransform.iri(c.getPredicate(), r);
                return new Tail(c.getSubject(), (String)step1 + "/" + step2);
            }
        }
        return null;
    }

    static String normalizePrePrefix(String s) {
        if (s == null) {
            return null;
        }
        String t = s.trim();
        if (!t.startsWith("((")) {
            return t;
        }
        int sep = t.indexOf(")/(");
        if (sep <= 0) {
            return t;
        }
        String left = t.substring(2, sep);
        Object rightWithParens = t.substring(sep + 2);
        if (((String)rightWithParens).length() >= 2 && ((String)rightWithParens).charAt(0) == '(') {
            if (((String)rightWithParens).endsWith(")?") && ((String)rightWithParens).length() >= 3 && ((String)rightWithParens).charAt(((String)rightWithParens).length() - 3) == ')') {
                String inner = ((String)rightWithParens).substring(1, ((String)rightWithParens).length() - 3);
                rightWithParens = "(" + inner + ")?";
            } else if (((String)rightWithParens).charAt(((String)rightWithParens).length() - 1) == ')') {
                String inner = ((String)rightWithParens).substring(1, ((String)rightWithParens).length() - 1);
                rightWithParens = "(" + inner + ")";
            }
        }
        return "((" + left + ")/" + (String)rightWithParens;
    }

    static final class Tail {
        final Var end;
        final String path;

        Tail(Var end, String path) {
            this.end = end;
            this.path = path;
        }
    }
}

