/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.config;

import java.util.Arrays;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;
import org.eclipse.rdf4j.repository.config.RepositoryFactory;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryRegistry;

public class AbstractRepositoryImplConfig
implements RepositoryImplConfig {
    private String type;

    public AbstractRepositoryImplConfig() {
    }

    public AbstractRepositoryImplConfig(String type) {
        this();
        this.setType(type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void validate() throws RepositoryConfigException {
        if (this.type == null) {
            throw new RepositoryConfigException("No type specified for repository implementation");
        }
    }

    @Override
    public Resource export(Model model) {
        if (Configurations.useLegacyConfig()) {
            return this.exportLegacy(model);
        }
        BNode implNode = Values.bnode();
        if (this.type != null) {
            model.add(implNode, CONFIG.Rep.type, Values.literal(this.type), new Resource[0]);
        }
        return implNode;
    }

    private Resource exportLegacy(Model model) {
        BNode implNode = Values.bnode();
        if (this.type != null) {
            model.add(implNode, RepositoryConfigSchema.REPOSITORYTYPE, Values.literal(this.type), new Resource[0]);
        }
        return implNode;
    }

    @Override
    public void parse(Model model, Resource resource) throws RepositoryConfigException {
        Configurations.getLiteralValue(model, resource, CONFIG.Rep.type, RepositoryConfigSchema.REPOSITORYTYPE).ifPresent(typeLit -> this.setType(typeLit.getLabel()));
    }

    public static RepositoryImplConfig create(Model model, Resource resource) throws RepositoryConfigException {
        try {
            Literal typeLit = Configurations.getLiteralValue(model, resource, CONFIG.Rep.type, RepositoryConfigSchema.REPOSITORYTYPE).orElse(null);
            if (typeLit != null) {
                RepositoryFactory factory = (RepositoryFactory)RepositoryRegistry.getInstance().get(typeLit.getLabel()).orElseThrow(() -> new RepositoryConfigException("Unsupported repository type: '" + typeLit.getLabel() + "' supported types are: " + Arrays.toString(RepositoryRegistry.getInstance().getKeys().toArray())));
                RepositoryImplConfig implConfig = factory.getConfig();
                implConfig.parse(model, resource);
                return implConfig;
            }
            return null;
        }
        catch (ModelException e) {
            throw new RepositoryConfigException(e.getMessage(), e);
        }
    }
}

