/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.collection.factory.mapdb;

import java.io.IOException;
import org.eclipse.rdf4j.collection.factory.api.BindingSetKey;
import org.eclipse.rdf4j.collection.factory.mapdb.MapDb3BindingSetKey;
import org.eclipse.rdf4j.collection.factory.mapdb.MapDb3CollectionFactory;
import org.eclipse.rdf4j.model.Value;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.mapdb.serializer.SerializerBoolean;
import org.mapdb.serializer.SerializerIntegerPacked;

class BindingSetKeySerializer
implements Serializer<BindingSetKey> {
    private final SerializerBoolean sb = new SerializerBoolean();
    private final SerializerIntegerPacked si = new SerializerIntegerPacked();
    private final Serializer<Value> vs;

    public BindingSetKeySerializer(Serializer<Value> vs) {
        this.vs = vs;
    }

    public void serialize(DataOutput2 out, BindingSetKey value) throws IOException {
        if (value == null) {
            this.sb.serialize(out, Boolean.valueOf(true));
        } else {
            this.sb.serialize(out, Boolean.valueOf(false));
            try {
                MapDb3BindingSetKey k = (MapDb3BindingSetKey)value;
                this.si.serialize(out, Integer.valueOf(k.hashCode()));
                this.si.serialize(out, Integer.valueOf(k.values.length));
                for (int i = 0; i < k.values.length; ++i) {
                    this.vs.serialize(out, (Object)k.values[i]);
                }
            }
            catch (ClassCastException e) {
                throw new MapDb3CollectionFactory.RDF4jMapDB3Exception("Collection factory overriden in an non conformat way", e);
            }
        }
    }

    public BindingSetKey deserialize(DataInput2 input, int available) throws IOException {
        if (this.sb.deserialize(input, available).booleanValue()) {
            return null;
        }
        int hashCode = this.si.deserialize(input, available);
        int length = this.si.deserialize(input, available);
        Value[] values = new Value[length];
        for (int i = 0; i < length; ++i) {
            values[i] = (Value)this.vs.deserialize(input, available);
        }
        return new MapDb3BindingSetKey(values, hashCode);
    }
}

