/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.deseralization;

import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdErrorCode;
import no.hasmac.jsonld.JsonLdOptions;
import no.hasmac.jsonld.deseralization.ObjectToRdf;
import no.hasmac.jsonld.flattening.NodeMap;
import no.hasmac.jsonld.json.JsonUtils;
import no.hasmac.jsonld.lang.BlankNode;
import no.hasmac.jsonld.lang.Keywords;
import no.hasmac.jsonld.lang.Utils;
import no.hasmac.jsonld.uri.UriUtils;
import no.hasmac.rdf.RdfConsumer;
import no.hasmac.rdf.RdfValueFactory;

public final class JsonLdToRdf<Triple, Quad, Iri extends Resource, Bnode extends Resource, Resource extends Value, Literal extends Value, Value> {
    private static final Logger LOGGER = Logger.getLogger(JsonLdToRdf.class.getName());
    private final NodeMap nodeMap;
    private final RdfConsumer<Triple, Quad> dataset;
    private final RdfValueFactory<Triple, Quad, Iri, Bnode, Resource, Literal, Value> rdfValueFactory;
    private final JsonLdOptions options;
    private JsonLdOptions.RdfDirection rdfDirection;
    private boolean uriValidation;

    private JsonLdToRdf(NodeMap nodeMap, RdfConsumer<Triple, Quad> dataset, RdfValueFactory<Triple, Quad, Iri, Bnode, Resource, Literal, Value> rdfValueFactory, JsonLdOptions options) {
        this.nodeMap = nodeMap;
        this.dataset = dataset;
        this.rdfValueFactory = rdfValueFactory;
        this.rdfDirection = null;
        this.uriValidation = true;
        this.options = options;
    }

    public static <Triple, Quad, Iri extends Resource, Bnode extends Resource, Resource extends Value, Literal extends Value, Value> JsonLdToRdf<Triple, Quad, Iri, Bnode, Resource, Literal, Value> with(NodeMap nodeMap, RdfConsumer<Triple, Quad> dataset, RdfValueFactory<Triple, Quad, Iri, Bnode, Resource, Literal, Value> rdfValueFactory, JsonLdOptions options) {
        return new JsonLdToRdf<Triple, Quad, Iri, Bnode, Resource, Literal, Value>(nodeMap, dataset, rdfValueFactory, options);
    }

    public JsonLdToRdf<Triple, Quad, Iri, Bnode, Resource, Literal, Value> rdfDirection(JsonLdOptions.RdfDirection rdfDirection) {
        this.rdfDirection = rdfDirection;
        return this;
    }

    public void build() throws JsonLdError {
        for (String graphName : Utils.index(this.nodeMap.graphs(), true)) {
            Object rdfGraphName;
            if ("@default".equals(graphName)) {
                rdfGraphName = null;
            } else if (BlankNode.isWellFormed(graphName)) {
                rdfGraphName = this.rdfValueFactory.createBlankNode(graphName);
            } else {
                if (!UriUtils.isAbsoluteUri(graphName, this.uriValidation)) continue;
                rdfGraphName = this.rdfValueFactory.createIRI(graphName);
            }
            for (String subject : Utils.index(this.nodeMap.subjects(graphName), true)) {
                Object rdfSubject;
                if (BlankNode.isWellFormed(subject)) {
                    rdfSubject = this.rdfValueFactory.createBlankNode(subject);
                } else if (UriUtils.isAbsoluteUri(subject, this.uriValidation)) {
                    rdfSubject = this.rdfValueFactory.createIRI(subject);
                } else {
                    LOGGER.log(Level.WARNING, "Non well-formed subject [{0}].", subject);
                    if (!this.options.isExceptionOnWarning()) continue;
                    throw new JsonLdError(JsonLdErrorCode.UNSPECIFIED, "Non well-formed subject [" + subject + "].");
                }
                for (String property : Utils.index(this.nodeMap.properties(graphName, subject), true)) {
                    Object rdfProperty;
                    if ("@type".equals(property)) {
                        for (JsonValue type : this.nodeMap.get(graphName, subject, property).asJsonArray()) {
                            Object rdfObject;
                            if (JsonUtils.isNotString(type)) continue;
                            String typeString = ((JsonString)type).getString();
                            if (BlankNode.isWellFormed(typeString)) {
                                rdfObject = this.rdfValueFactory.createBlankNode(typeString);
                            } else {
                                if (!UriUtils.isAbsoluteUri(typeString, this.uriValidation)) continue;
                                rdfObject = this.rdfValueFactory.createIRI(typeString);
                            }
                            this.dataset.handleQuad(this.rdfValueFactory.createQuad(rdfSubject, this.rdfValueFactory.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), rdfObject, rdfGraphName));
                        }
                        continue;
                    }
                    if (Keywords.contains(property) || (rdfProperty = UriUtils.isAbsoluteUri(property, this.uriValidation) ? (Object)this.rdfValueFactory.createIRI(property) : null) == null) continue;
                    for (JsonValue item : this.nodeMap.get(graphName, subject, property).asJsonArray()) {
                        ArrayList listTriples = new ArrayList();
                        Value rdfValue = ObjectToRdf.with(item.asJsonObject(), listTriples, this.nodeMap, this.rdfValueFactory, this.options).rdfDirection(this.rdfDirection).uriValidation(this.uriValidation).build();
                        if (rdfValue != null) {
                            this.dataset.handleQuad(this.rdfValueFactory.createQuad(rdfSubject, rdfProperty, rdfValue, rdfGraphName));
                        }
                        listTriples.stream().map(triple -> this.rdfValueFactory.createQuad(triple, rdfGraphName)).forEach(this.dataset::handleQuad);
                    }
                }
            }
        }
    }

    public JsonLdToRdf<Triple, Quad, Iri, Bnode, Resource, Literal, Value> uriValidation(boolean uriValidation) {
        this.uriValidation = uriValidation;
        return this;
    }
}

