/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.ReportResourceChangeEvent;
import org.eclipse.birt.report.designer.internal.ui.wizards.WizardCSSSettingPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.views.IReportResourceSynchronizer;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class PublishCSSWizard
extends Wizard {
    private static String WINDOWS_TITLE = Messages.getString((String)"PublishCSSDialog.ShellText");
    private static String PAGE_TITLE = Messages.getString((String)"PublishCSSDialog.TitleArea");
    private static String PAGE_DESC = Messages.getString((String)"PublishCSSDialog.Message");
    private String filePath;
    private String fileName = null;
    private String folderName;
    private WizardCSSSettingPage page;
    private String widonwTitle;
    private String pageTitle;
    private String pageDescription;

    public void setWizardTitle(String wizardTitle) {
        this.widonwTitle = wizardTitle;
        this.setWindowTitle(this.widonwTitle);
    }

    public void setPageTitle(String PageTitle) {
        this.pageTitle = PageTitle;
    }

    public void setPageDesc(String pageDesc) {
        this.pageDescription = pageDesc;
    }

    public PublishCSSWizard(String folderName) {
        this.folderName = folderName;
        this.setWizardTitle(WINDOWS_TITLE);
        this.setPageTitle(PAGE_TITLE);
        this.setPageDesc(PAGE_DESC);
    }

    public void addPages() {
        this.page = new WizardCSSSettingPage(this.pageTitle, this.pageDescription);
        if (this.fileName != null) {
            this.page.setFileName(this.fileName);
        }
        this.page.setfolderName(this.folderName);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.fileName = this.page.getFileName();
        this.folderName = this.page.getFolder();
        this.filePath = this.page.getSourceFileName();
        return this.publishiCSSFile();
    }

    public boolean canFinish() {
        return this.page.canFinish();
    }

    private boolean publishiCSSFile() {
        if (!new File(this.filePath).exists()) {
            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"PublishCSSAction.wizard.errorTitle"), Messages.getString((String)"PublishCSSAction.wizard.message.SourceFileNotExist"));
            return true;
        }
        File targetFolder = new File(this.folderName);
        if (targetFolder.exists() && !targetFolder.isDirectory()) {
            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"PublishCSSAction.wizard.errorTitle"), Messages.getString((String)"PublishCSSAction.wizard.notvalidfolder"));
            return true;
        }
        boolean folderExists = targetFolder.exists();
        if (!folderExists) {
            folderExists = targetFolder.mkdirs();
        }
        if (!folderExists) {
            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"PublishCSSAction.wizard.errorTitle"), Messages.getString((String)"PublishCSSAction.wizard.msgDirErr"));
            return false;
        }
        File targetFile = new File(targetFolder, this.fileName);
        if (new File(this.filePath).compareTo(targetFile) == 0) {
            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"PublishCSSAction.wizard.errorTitle"), Messages.getString((String)"PublishCSSAction.wizard.message"));
            return false;
        }
        int overwrite = 0;
        try {
            if (targetFile.exists()) {
                String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                String question = Messages.getFormattedString((String)"SaveAsDialog.overwriteQuestion", (Object[])new Object[]{targetFile.getAbsolutePath()});
                MessageDialog d = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"SaveAsDialog.Question"), null, question, 3, buttons, 0);
                overwrite = d.open();
            }
            if (overwrite == 0 && (targetFile.exists() || !targetFile.exists() && targetFile.createNewFile())) {
                this.copyFile(this.filePath, targetFile);
                IReportResourceSynchronizer synchronizer = ReportPlugin.getDefault().getResourceSynchronizerService();
                if (synchronizer != null) {
                    synchronizer.notifyResourceChanged(new ReportResourceChangeEvent((Object)this, Path.fromOSString((String)targetFile.getAbsolutePath()), 1));
                }
            }
        }
        catch (IOException e) {
            ExceptionHandler.handle(e);
        }
        return overwrite != 1;
    }

    private void copyFile(String in, File targetFile) throws IOException {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(targetFile);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }
}

