/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.preference.IPreferences;
import org.eclipse.birt.report.designer.ui.preferences.IStatusChangeListener;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.designer.ui.util.PixelConverter;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class OptionsConfigurationBlock {
    protected final ArrayList fCheckBoxes;
    protected final ArrayList fComboBoxes;
    protected final ArrayList fTextBoxes;
    protected final ArrayList fRadioButtons;
    protected final HashMap fLabels;
    protected final ArrayList fExpandedComposites;
    private SelectionListener fSelectionListener;
    private ModifyListener fTextModifyListener;
    protected IStatusChangeListener fContext;
    protected IProject fProject;
    protected Key[] fAllKeys;
    protected Key[] ignoreKeys;
    protected AbstractUIPlugin fPlugin;
    protected IPreferences fPref;
    private Shell fShell;
    private Map fDisabledProjectSettings;

    public OptionsConfigurationBlock(IStatusChangeListener context, AbstractUIPlugin plugin, IProject project) {
        this.fContext = context;
        this.fProject = project;
        this.fPlugin = plugin;
        this.fPref = PreferenceFactory.getInstance().getPreferences(this.fPlugin, this.fProject);
        this.fCheckBoxes = new ArrayList();
        this.fComboBoxes = new ArrayList();
        this.fTextBoxes = new ArrayList(2);
        this.fRadioButtons = new ArrayList();
        this.fLabels = new HashMap();
        this.fExpandedComposites = new ArrayList();
    }

    public void setKeys(Key[] keys) {
        this.fAllKeys = keys;
        if (this.fProject == null || this.hasProjectSpecificOptions(this.fProject)) {
            this.fDisabledProjectSettings = null;
        } else {
            this.fDisabledProjectSettings = new IdentityHashMap();
            int i = 0;
            while (i < keys.length) {
                Key curr = keys[i];
                this.fDisabledProjectSettings.put(curr, curr.getStoredValue(this.fPref));
                ++i;
            }
        }
        this.settingsUpdated();
    }

    public void setIngoreProjectSettingKeys(Key[] keys) {
        this.ignoreKeys = keys;
    }

    protected void settingsUpdated() {
    }

    protected Key getKey(String plugin, String key) {
        return new Key(plugin, key);
    }

    protected final Key getReportKey(String key) {
        return this.getKey("org.eclipse.birt.report.designer.ui", key);
    }

    public void selectOption(String key, String qualifier) {
        int i = 0;
        while (i < this.fAllKeys.length) {
            Key curr = this.fAllKeys[i];
            if (curr.getName().equals(key) && curr.getQualifier().equals(qualifier)) {
                this.selectOption(curr);
            }
            ++i;
        }
    }

    public void selectOption(Key key) {
        Control control = this.findControl(key);
        if (control != null) {
            control.setFocus();
        }
    }

    protected Shell getShell() {
        return this.fShell;
    }

    protected void setShell(Shell shell) {
        this.fShell = shell;
    }

    protected abstract Control createContents(Composite var1);

    protected RadioComposite addRadioButton(Composite parent, String[] labels, Key key, String[] values, int indent) {
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = indent;
        RadioComposite composite = new RadioComposite(parent, 0);
        composite.setLayoutData(gd);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        composite.setText(labels[0]);
        int i = 1;
        while (i < labels.length) {
            Button radioBtn = new Button((Composite)composite, 16);
            radioBtn.setFont(JFaceResources.getDialogFont());
            radioBtn.setLayoutData((Object)new GridData());
            radioBtn.setText(labels[i]);
            ++i;
        }
        composite.setData(data);
        composite.addSelectionListener(this.getSelectionListener());
        String currValue = this.getValue(key);
        composite.setSelection(data.getSelection(currValue));
        this.fRadioButtons.add(composite);
        this.updateRadioComposite(composite);
        return composite;
    }

    protected Button addCheckBox(Composite parent, String label, Key key, String[] values, int indent) {
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = indent;
        Button checkBox = new Button(parent, 32);
        checkBox.setFont(JFaceResources.getDialogFont());
        checkBox.setText(label);
        checkBox.setData((Object)data);
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.getSelectionListener());
        String currValue = this.getValue(key);
        checkBox.setSelection(data.getSelection(currValue) == 0);
        this.fCheckBoxes.add(checkBox);
        this.updateCheckBox(checkBox);
        return checkBox;
    }

    protected Button addCheckBoxWithLink(Composite parent, String label, Key key, String[] values, int indent, int widthHint, SelectionListener listener) {
        String currValue;
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = indent;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gd);
        Button checkBox = new Button(composite, 32);
        checkBox.setFont(JFaceResources.getDialogFont());
        checkBox.setData((Object)data);
        checkBox.setLayoutData((Object)new GridData(4, 1, false, false));
        checkBox.addSelectionListener(this.getSelectionListener());
        gd = new GridData(4, 2, true, false);
        gd.widthHint = widthHint;
        Link link = new Link(composite, 0);
        link.setText(label);
        link.setLayoutData((Object)gd);
        if (listener != null) {
            link.addSelectionListener(listener);
        }
        checkBox.setSelection(data.getSelection(currValue = this.getValue(key)) == 0);
        this.fCheckBoxes.add(checkBox);
        this.updateCheckBox(checkBox);
        return checkBox;
    }

    protected Combo addComboBox(Composite parent, String label, Key key, String[] values, String[] valueLabels, int indent) {
        GridData gd = new GridData();
        gd.horizontalIndent = indent;
        Label labelControl = new Label(parent, 0);
        labelControl.setFont(JFaceResources.getDialogFont());
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo comboBox = this.newComboControl(parent, key, values, valueLabels);
        gd = new GridData();
        gd.widthHint = 200;
        comboBox.setLayoutData((Object)gd);
        this.fLabels.put(comboBox, labelControl);
        this.updateCombo(comboBox);
        return comboBox;
    }

    protected Combo addInversedComboBox(Composite parent, String label, Key key, String[] values, String[] valueLabels, int indent) {
        GridData gd = new GridData(32);
        gd.horizontalIndent = indent;
        gd.horizontalSpan = 3;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gd);
        Combo comboBox = this.newComboControl(composite, key, values, valueLabels);
        comboBox.setFont(JFaceResources.getDialogFont());
        comboBox.setLayoutData((Object)new GridData(256));
        Label labelControl = new Label(composite, 16448);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)new GridData());
        this.fLabels.put(comboBox, labelControl);
        this.updateCombo(comboBox);
        return comboBox;
    }

    protected Combo newComboControl(Composite composite, Key key, String[] values, String[] valueLabels) {
        ControlData data = new ControlData(key, values);
        Combo comboBox = new Combo(composite, 8);
        comboBox.setVisibleItemCount(30);
        comboBox.setItems(valueLabels);
        comboBox.setData((Object)data);
        comboBox.addSelectionListener(this.getSelectionListener());
        comboBox.setFont(JFaceResources.getDialogFont());
        String currValue = this.getValue(key);
        comboBox.select(data.getSelection(currValue));
        this.fComboBoxes.add(comboBox);
        return comboBox;
    }

    protected Text addTextField(Composite parent, String label, Key key, int indent, int widthHint) {
        return this.addTextField(parent, label, key, indent, widthHint, 2052);
    }

    protected Text addTextField(Composite parent, String label, Key key, int indent, int widthHint, int style) {
        String currValue;
        Label labelControl = null;
        if (label != null && label.length() > 0) {
            labelControl = new Label(parent, 64);
            labelControl.setText(label);
            labelControl.setFont(JFaceResources.getDialogFont());
            labelControl.setLayoutData((Object)new GridData());
        }
        Text textBox = new Text(parent, style);
        textBox.setData((Object)key);
        textBox.setLayoutData((Object)new GridData());
        if (labelControl != null) {
            this.fLabels.put(textBox, labelControl);
        }
        if ((currValue = this.getValue(key)) != null) {
            textBox.setText(currValue);
        }
        textBox.addModifyListener(this.getTextModifyListener());
        GridData data = new GridData(256);
        if (widthHint != 0) {
            data.widthHint = widthHint;
        } else {
            data.grabExcessHorizontalSpace = true;
        }
        data.horizontalIndent = indent;
        data.horizontalSpan = labelControl != null ? 2 : 3;
        textBox.setLayoutData((Object)data);
        this.fTextBoxes.add(textBox);
        this.updateText(textBox);
        return textBox;
    }

    protected SelectionListener getSelectionListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    OptionsConfigurationBlock.this.controlChanged(e.widget);
                }
            };
        }
        return this.fSelectionListener;
    }

    protected ModifyListener getTextModifyListener() {
        if (this.fTextModifyListener == null) {
            this.fTextModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OptionsConfigurationBlock.this.textChanged((Text)e.widget);
                }
            };
        }
        return this.fTextModifyListener;
    }

    protected void controlChanged(Widget widget) {
        ControlData data = (ControlData)widget.getData();
        String newValue = null;
        if (widget instanceof Button) {
            if ((((Button)widget).getStyle() & 0x10) != 0) {
                RadioComposite parent = (RadioComposite)((Button)widget).getParent();
                data = (ControlData)parent.getData();
                newValue = data.getValue(parent.getBtnIndex((Button)widget));
            } else {
                newValue = data.getValue(((Button)widget).getSelection());
            }
        } else if (widget instanceof Combo) {
            newValue = data.getValue(((Combo)widget).getSelectionIndex());
        } else {
            return;
        }
        String oldValue = this.setValue(data.getKey(), newValue);
        this.validateSettings(data.getKey(), oldValue, newValue);
    }

    protected void textChanged(Text textControl) {
        Key key = (Key)textControl.getData();
        String number = textControl.getText();
        String oldValue = this.setValue(key, number);
        this.validateSettings(key, oldValue, number);
    }

    protected boolean checkValue(Key key, String value) {
        return value.equals(this.getValue(key));
    }

    protected String getValue(Key key) {
        if (this.fDisabledProjectSettings != null) {
            return (String)this.fDisabledProjectSettings.get(key);
        }
        return key.getStoredValue(this.fPref);
    }

    protected boolean getBooleanValue(Key key) {
        return Boolean.valueOf(this.getValue(key));
    }

    protected String setValue(Key key, String value) {
        if (this.fDisabledProjectSettings != null) {
            return this.fDisabledProjectSettings.put(key, value);
        }
        String oldValue = this.getValue(key);
        key.setStoredValue(this.fPref, value);
        return oldValue;
    }

    protected String setValue(Key key, boolean value) {
        return this.setValue(key, String.valueOf(value));
    }

    protected String getStoredValue(Key key) {
        return key.getStoredValue(this.fPref);
    }

    public void useProjectSpecificSettings(boolean enable) {
        boolean hasProjectSpecificOption;
        boolean bl = hasProjectSpecificOption = this.fDisabledProjectSettings == null;
        if (enable != hasProjectSpecificOption && this.fProject != null) {
            if (enable) {
                int i = 0;
                while (i < this.fAllKeys.length) {
                    Key curr = this.fAllKeys[i];
                    String val = (String)this.fDisabledProjectSettings.get(curr);
                    curr.setStoredValue(this.fPref, val);
                    ++i;
                }
                this.fDisabledProjectSettings = null;
                this.updateControls();
                this.validateSettings(null, null, null);
            } else {
                this.fDisabledProjectSettings = new IdentityHashMap();
                int i = 0;
                while (i < this.fAllKeys.length) {
                    Key curr = this.fAllKeys[i];
                    String oldSetting = curr.getStoredValue(this.fPref);
                    this.fDisabledProjectSettings.put(curr, oldSetting);
                    ++i;
                }
            }
        }
    }

    public boolean hasProjectSpecificOptions(IProject project) {
        if (project != null) {
            Key[] allKeys = this.fAllKeys;
            IPreferences prefs = PreferenceFactory.getInstance().getPreferences(this.fPlugin, project);
            int i = 0;
            while (i < allKeys.length) {
                if (prefs.isDefault(allKeys[i].getName())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean areSettingsEnabled() {
        return this.fDisabledProjectSettings == null || this.fProject == null;
    }

    public boolean performOk() {
        return this.performApply();
    }

    public boolean performApply() {
        return this.processChanges();
    }

    protected boolean processChanges() {
        if (this.fDisabledProjectSettings != null) {
            int i = 0;
            while (i < this.fAllKeys.length) {
                if (this.fProject == null || this.ignoreKeys == null || !Arrays.asList(this.ignoreKeys).contains(this.fAllKeys[i])) {
                    this.fAllKeys[i].setToDefault(this.fPref);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.fAllKeys.length) {
                if (this.fProject == null || this.ignoreKeys == null || !Arrays.asList(this.ignoreKeys).contains(this.fAllKeys[i])) {
                    this.fAllKeys[i].apply(this.fPref);
                }
                ++i;
            }
        }
        try {
            this.fPref.save();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void performDefaults() {
        int i = 0;
        while (i < this.fAllKeys.length) {
            Key curr = this.fAllKeys[i];
            String defValue = this.fAllKeys[i].getDefaultValue(this.fPref);
            this.setValue(curr, defValue);
            ++i;
        }
        this.settingsUpdated();
        this.updateControls();
        this.validateSettings(null, null, null);
    }

    public void dispose() {
    }

    protected void updateControls() {
        int i = this.fCheckBoxes.size() - 1;
        while (i >= 0) {
            this.updateCheckBox((Button)this.fCheckBoxes.get(i));
            --i;
        }
        i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            this.updateCombo((Combo)this.fComboBoxes.get(i));
            --i;
        }
        i = this.fTextBoxes.size() - 1;
        while (i >= 0) {
            this.updateText((Text)this.fTextBoxes.get(i));
            --i;
        }
        i = this.fRadioButtons.size() - 1;
        while (i >= 0) {
            this.updateRadioComposite((RadioComposite)((Object)this.fRadioButtons.get(i)));
            --i;
        }
    }

    protected void updateCombo(Combo curr) {
        ControlData data = (ControlData)curr.getData();
        String currValue = this.getValue(data.getKey());
        curr.select(data.getSelection(currValue));
        if (this.fProject != null && this.ignoreKeys != null && Arrays.asList(this.ignoreKeys).contains(data.getKey())) {
            ControlEnableState.disable((Control)curr);
            Control label = (Control)this.fLabels.get(curr);
            if (label != null) {
                ControlEnableState.disable((Control)label);
            }
        }
    }

    protected void updateCheckBox(Button curr) {
        String currValue;
        ControlData data = (ControlData)curr.getData();
        curr.setSelection(data.getSelection(currValue = this.getValue(data.getKey())) == 0);
        if (this.fProject != null && this.ignoreKeys != null && Arrays.asList(this.ignoreKeys).contains(data.getKey())) {
            ControlEnableState.disable((Control)curr);
        }
    }

    protected void updateRadioComposite(RadioComposite curr) {
        ControlData data = (ControlData)curr.getData();
        String currValue = this.getValue(data.getKey());
        curr.setSelection(data.getSelection(currValue));
        if (this.fProject != null && this.ignoreKeys != null && Arrays.asList(this.ignoreKeys).contains(data.getKey())) {
            ControlEnableState.disable((Control)curr);
        }
    }

    protected void updateText(Text curr) {
        Key key = (Key)curr.getData();
        String currValue = this.getValue(key);
        if (currValue != null) {
            curr.setText(currValue);
        }
        if (this.fProject != null && this.ignoreKeys != null && Arrays.asList(this.ignoreKeys).contains(key)) {
            ControlEnableState.disable((Control)curr);
            Control label = (Control)this.fLabels.get(curr);
            if (label != null) {
                ControlEnableState.disable((Control)label);
            }
        }
    }

    protected Button getCheckBox(Key key) {
        int i = this.fCheckBoxes.size() - 1;
        while (i >= 0) {
            Button curr = (Button)this.fCheckBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        return null;
    }

    protected Combo getComboBox(Key key) {
        int i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            Combo curr = (Combo)this.fComboBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        return null;
    }

    protected Text getTextControl(Key key) {
        int i = this.fTextBoxes.size() - 1;
        while (i >= 0) {
            Text curr = (Text)this.fTextBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        return null;
    }

    protected Control findControl(Key key) {
        Combo comboBox = this.getComboBox(key);
        if (comboBox != null) {
            return comboBox;
        }
        Button checkBox = this.getCheckBox(key);
        if (checkBox != null) {
            return checkBox;
        }
        Text text = this.getTextControl(key);
        if (text != null) {
            return text;
        }
        return null;
    }

    protected void setComboEnabled(Key key, boolean enabled) {
        Combo combo = this.getComboBox(key);
        Label label = (Label)this.fLabels.get(combo);
        combo.setEnabled(enabled);
        label.setEnabled(enabled);
    }

    protected Text addLabelledTextField(Composite parent, String label, Key key, int textlimit, int indent, boolean dummy) {
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        Label labelControl = new Label(parent, 64);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)new GridData());
        Text textBox = new Text(parent, 2052);
        textBox.setData((Object)key);
        textBox.setLayoutData((Object)new GridData());
        this.fLabels.put(textBox, labelControl);
        String currValue = this.getValue(key);
        if (currValue != null) {
            textBox.setText(currValue);
        }
        textBox.addModifyListener(this.getTextModifyListener());
        GridData data = new GridData(256);
        if (textlimit != 0) {
            textBox.setTextLimit(textlimit);
            data.widthHint = pixelConverter.convertWidthInCharsToPixels(textlimit + 1);
        }
        data.horizontalIndent = indent;
        data.horizontalSpan = 2;
        textBox.setLayoutData((Object)data);
        this.fTextBoxes.add(textBox);
        return textBox;
    }

    protected void validateSettings(Key changedKey, String oldValue, String newValue) {
    }

    protected static class ControlData {
        private Key fKey;
        private String[] fValues;

        public ControlData(Key key, String[] values) {
            this.fKey = key;
            this.fValues = values;
        }

        public Key getKey() {
            return this.fKey;
        }

        public String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.fValues[index];
        }

        public String getValue(int index) {
            return this.fValues[index];
        }

        public int getSelection(String value) {
            if (value != null) {
                int i = 0;
                while (i < this.fValues.length) {
                    if (value.equals(this.fValues[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return this.fValues.length - 1;
        }
    }

    public static final class Key {
        private String fQualifier;
        private String fKey;
        private String value;

        public Key(String qualifier, String key) {
            this.fQualifier = qualifier;
            this.fKey = key;
        }

        public String getName() {
            return this.fKey;
        }

        public void apply(IPreferences preference) {
            if (this.value != null) {
                preference.setValue(this.fKey, this.value);
            }
        }

        public String getStoredValue(IPreferences preference) {
            if (this.value == null) {
                this.value = preference.getString(this.fKey);
            }
            return this.value;
        }

        public String getDefaultValue(IPreferences preference) {
            return preference.getDefaultString(this.fKey);
        }

        public void setStoredValue(IPreferences preference, String value) {
            if (value != null) {
                this.value = value;
            }
        }

        public void setToDefault(IPreferences preference) {
            preference.setToDefault(this.fKey);
            this.value = preference.getString(this.fKey);
        }

        public String toString() {
            return String.valueOf(this.fQualifier) + '/' + this.fKey;
        }

        public String getQualifier() {
            return this.fQualifier;
        }

        public void clear() {
            this.value = null;
        }
    }

    public static class RadioComposite
    extends Group {
        List<Button> radioBtns = new ArrayList<Button>();

        public RadioComposite(Composite parent, int style) {
            super(parent, style);
        }

        protected void checkSubclass() {
        }

        private void IniRadioButtons() {
            if (this.radioBtns.size() > 0) {
                return;
            }
            Control[] controls = this.getChildren();
            int i = 0;
            while (i < controls.length) {
                if (controls[i] != null && controls[i] instanceof Button) {
                    this.radioBtns.add((Button)controls[i]);
                }
                ++i;
            }
        }

        protected int getBtnIndex(Button btn) {
            int index = this.radioBtns.indexOf(btn);
            return index;
        }

        protected void setSelection(int index) {
            this.IniRadioButtons();
            if (this.radioBtns.size() <= 0) {
                return;
            }
            if (index < 0 || index >= this.radioBtns.size()) {
                index = 0;
            }
            int i = 0;
            while (i < this.radioBtns.size()) {
                Button btn = this.radioBtns.get(i);
                if (i == index) {
                    btn.setSelection(true);
                } else {
                    btn.setSelection(false);
                }
                ++i;
            }
        }

        public void addSelectionListener(SelectionListener selectionListener) {
            this.IniRadioButtons();
            if (this.radioBtns.size() <= 0) {
                return;
            }
            int i = 0;
            while (i < this.radioBtns.size()) {
                this.radioBtns.get(i).addSelectionListener(selectionListener);
                ++i;
            }
        }
    }
}

